/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: replay.c,v 1.8 2007/05/12 09:58:02 bowkenken Exp $
***************************************************************/

/***************************************************************
* ץ쥤
***************************************************************/

#define	REPLAY_C
#include	"inc.h"

/***************************************************************/

static long	g_replay_save_slot;

static bool_t	g_flg_reg_replay[REPLAY_SLOT_MAX_N];
static long	g_replay_randm_seed[REPLAY_SLOT_MAX_N];
static replay_t	*g_replay_head[REPLAY_SLOT_MAX_N];
static replay_t	*g_replay_cur[REPLAY_SLOT_MAX_N];
static replay_t	*g_replay_cur_draw;

static bool_t	g_flg_play_replay;
static long	g_play_replay_turn;
static long	g_play_replay_count;

static long	g_play_replay_idx;
static long	g_play_replay_idx_draw;

/***************************************************************
* ץ쥤
***************************************************************/

void	init_replay( void )
{
	long	sn;

	g_replay_save_slot = SAVE_N_AUTO;

	for( sn = REPLAY_SLOT_NULL; sn < REPLAY_SLOT_MAX_N; sn++ ){
		g_flg_reg_replay[sn] = FALSE;
		g_replay_head[sn] = NULL;
		g_replay_cur[sn] = NULL;
	}
	g_replay_cur_draw = NULL;

	g_flg_play_replay = FALSE;
	g_play_replay_turn = -1;
	g_play_replay_count = 0;

	g_play_replay_idx = 0;
	g_play_replay_idx_draw = 0;
}

/***************************************************************
* ץ쥤ꥻå
* long n : ǡåֹ
***************************************************************/

void	reset_replay( long n )
{
	replay_slot_t	sn = cv_slot_n( n );

	reset_replay_slot( sn );
}

/***************************************************************
* ץ쥤ꥻå(åȻꤢ)
* replay_slot_t sn : ץ쥤åֹ
***************************************************************/

void	reset_replay_slot( replay_slot_t sn )
{
	replay_t	*p, *next;

	if( g_replay_head[sn] == NULL )
		return;

	for( p = g_replay_head[sn]; p != NULL; p = next ){
		next = p->next;
		free_replay( p );
	}

	g_flg_reg_replay[sn] = FALSE;
	g_replay_head[sn] = NULL;
	g_replay_cur[sn] = NULL;
	g_replay_cur_draw = NULL;
}

/***************************************************************
* ץ쥤εϿ֤֤
* long n : ǡåֹ
***************************************************************/

bool_t	chk_reg_replay( long n )
{
	replay_slot_t	sn = cv_slot_n( n );

	return g_flg_reg_replay[sn];
}

/***************************************************************
* ץ쥤εϿ򳫻
* long n : ǡåֹ
***************************************************************/

void	bgn_reg_replay( long n )
{
	replay_slot_t	sn = cv_slot_n( n );

	if( n != SAVE_N_AUTO )
		g_replay_save_slot = n;

	if( g_flg_reg_replay[sn] )
		reset_replay( n );

	g_replay_randm_seed[sn] = get_randm_seed();

	g_flg_reg_replay[sn] = TRUE;
	if( n != SAVE_N_AUTO )
		print_msg( FLG_NULL, MSG_BGN_REG_REPLAY );
}

/***************************************************************
* ץ쥤Υեɤ߹ߤ򳫻
***************************************************************/

void	bgn_reg_replay_play( void )
{
	replay_slot_t	sn = REPLAY_SLOT_PLAY;

	if( g_flg_reg_replay[sn] )
		reset_replay_slot( sn );

	g_flg_reg_replay[sn] = TRUE;
}

/***************************************************************
* ץ쥤εϿλ
* long n : ǡåֹ
***************************************************************/

void	end_reg_replay( long n )
{
	replay_slot_t	sn = cv_slot_n( n );

	if( !g_flg_reg_replay[sn] )
		return;

	g_flg_reg_replay[sn] = FALSE;
	print_msg( FLG_NULL, MSG_END_REG_REPLAY );
}

/***************************************************************
* ץ쥤ʸϿ
* replay_kind_t kind : ץ쥤μ
* char *str : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	set_replay_str(
	replay_kind_t kind, char *str
)
{
	bool_t	flg_success;
	replay_slot_t	sn;

	flg_success = TRUE;

	sn = REPLAY_SLOT_AUTO;
	if( !set_replay_str_slot( kind, sn, str ) )
		flg_success = FALSE;

	sn = cv_slot_n( g_replay_save_slot );
	if( !set_replay_str_slot( kind, sn, str ) )
		flg_success = FALSE;

	return flg_success;
}

/***************************************************************
* ץ쥤ʸϿ(åȻꤢ)
* replay_kind_t kind : ץ쥤μ
* replay_slot_t sn : ץ쥤åֹ
* char *str : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	set_replay_str_slot(
	replay_kind_t kind, replay_slot_t sn, char *str
)
{
	long	i;

	if( !g_flg_reg_replay[sn] )
		return TRUE;
	if( str == NULL )
		return FALSE;

	for( i = 0; str[i] != '\0'; i++ ){
		if( !set_replay_char_slot( kind, sn, str[i] ) )
			return FALSE;
	}

	return TRUE;
}

/***************************************************************
* ץ쥤 1 ʸϿ
* replay_kind_t kind : ץ쥤μ
* long c : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	set_replay_char(
	replay_kind_t kind, long c
)
{
	bool_t	flg_success;
	replay_slot_t	sn;

	flg_success = TRUE;

	sn = REPLAY_SLOT_AUTO;
	if( !set_replay_char_slot( kind, sn, c ) )
		flg_success = FALSE;

	sn = cv_slot_n( g_replay_save_slot );
	if( !set_replay_char_slot( kind, sn, c ) )
		flg_success = FALSE;

	return flg_success;
}

/***************************************************************
* ץ쥤 1 ʸϿ(åȻꤢ)
* replay_kind_t kind : ץ쥤μ
* replay_slot_t sn : ץ쥤åֹ
* long c : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	set_replay_char_slot(
	replay_kind_t kind, replay_slot_t sn, long c
)
{
	if( !g_flg_reg_replay[sn] )
		return TRUE;

	if( !ready_replay( sn, FALSE ) )
		return FALSE;

	if( kind != g_replay_cur[sn]->kind ){
		if( !ready_replay( sn, TRUE ) )
			return FALSE;

		g_replay_cur[sn]->kind = kind;
	}

	if( c != '\0' ){
		g_replay_cur[sn]->buf[g_replay_cur[sn]->n] = c;
		g_replay_cur[sn]->n++;
	}
	g_replay_cur[sn]->buf[g_replay_cur[sn]->n] = '\0';

	return TRUE;
}

/***************************************************************
* ץ쥤εϿν
* replay_slot_t sn : ץ쥤åֹ
* bool_t flg_break : Ū˹Ԥʬ䤹뤫?
* return : Ͽǽ?
***************************************************************/

bool_t	ready_replay( replay_slot_t sn, bool_t flg_break )
{
	if( !g_flg_reg_replay[sn] )
		return FALSE;

	if( g_replay_head[sn] == NULL ){
		g_replay_head[sn] = alloc_replay();
		g_replay_cur[sn] = g_replay_head[sn];

		if( g_replay_head[sn] == NULL )
			return FALSE;

		g_replay_cur[sn]->kind = REPLAY_KIND_KEY;
	}
	if( g_replay_cur[sn] == NULL )
		g_replay_cur[sn] = g_replay_head[sn];

	if( flg_break || (g_replay_cur[sn]->n >= REPLAY_BUF_MAX_LEN) ){
		g_replay_cur[sn]->next = alloc_replay();
		if( g_replay_cur[sn]->next == NULL )
			return FALSE;

		g_replay_cur[sn]->next->kind = g_replay_cur[sn]->kind;
		g_replay_cur[sn] = g_replay_cur[sn]->next;
	}

	return TRUE;
}

/***************************************************************
* ץ쥤ѥǡ֤
* char *buf : ꥹȤ֤
* long *idx : ߤΥΰ֤֤
* long *len : ߤΥĹ֤
* return : ɬפ뤫?
***************************************************************/

bool_t	get_draw_replay( char *buf, long *idx, long *len )
{
	bool_t	flg_redraw, flg_set_next;
	replay_t	*p, *next_p;
	long	n, next_n;
	char	tmp[1 + 1], *tmp2;
	long	len_tmp2;
	long	i;

	if( buf == NULL )
		return FALSE;
	buf[0] = '\0';

	if( idx == NULL )
		return FALSE;
	*idx = 0;

	if( len == NULL )
		return FALSE;
	*len = 1;

	flg_redraw = FALSE;
	flg_set_next = FALSE;

	p = g_replay_cur_draw;
	n = g_play_replay_idx_draw;
	next_p = p;
	next_n = n;

	if( p == NULL )
		return FALSE;

	for( i = 0; i < SCREEN_WIDTH - 2; i += len_tmp2 ){
		if( str_len_draw( buf ) >= SCREEN_WIDTH )
			break;

		tmp[0] = get_replay_next_key( &p, &n );
		tmp[1] = '\0';
		if( tmp[0] == '\0' )
			break;
		tmp2 = cv_esc_ctrl_str( tmp );
		len_tmp2 = str_len_draw( tmp2 );
		str_max_n_cat( buf, tmp2, SCREEN_WIDTH );

		if( !flg_set_next && (i == (SCREEN_WIDTH / 2)) ){
			flg_set_next = TRUE;
			next_p = p;
			next_n = n;
		}

		if( (p == g_replay_cur[REPLAY_SLOT_PLAY])
				&& (n >= g_play_replay_idx)
				&& (*idx == 0) ){
			*idx = i;
			*len = len_tmp2;

			if( i > (SCREEN_WIDTH * 3 / 4) ){
				flg_redraw = TRUE;

				g_replay_cur_draw = next_p;
				g_play_replay_idx_draw = next_n;
				p = next_p;
				n = next_n;

				i = 0 - len_tmp2;
			}
		}
	}
	buf[i] = '\0';

	return flg_redraw;
}

/***************************************************************
* ץ쥤Υå
* long c : ץ쥤
***************************************************************/

void	chk_replay_key( long c )
{
	if( !g_flg_play_replay )
		return;

	switch( c ){
	default:
	case CASE_ENTER:
		g_play_replay_count = 1;
		break;
	case ' ':
		g_play_replay_count = 10;
		break;
	case CASE_EXEC:
		g_play_replay_turn = get_turn();
		break;
	case CASE_CANCEL:
	case 'Q':
	case 'Q' - '@':
	case 'C' - '@':
		set_flg_play_replay( FALSE );
		break;
	}
}

/***************************************************************
* ץ쥤ξ֤˱ƥץ쥤֤
* return : ץ쥤
***************************************************************/

long	get_replay_key( void )
{
	replay_t	**pp;
	long	*idx;

	if( !g_flg_play_replay )
		return '\0';

	pp = &(g_replay_cur[REPLAY_SLOT_PLAY]);
	idx = &g_play_replay_idx;

	if( g_play_replay_turn == get_turn() )
		return get_replay_next_key( pp, idx );

	g_play_replay_turn = -1;

	if( g_play_replay_count > 0 ){
		g_play_replay_count--;
		return get_replay_next_key( pp, idx );
	}

	return '\0';
}

/***************************************************************
* Υץ쥤֤
* return : ץ쥤
***************************************************************/

long	get_replay_next_key( replay_t **pp, long *idx )
{
	long	c;

	if( pp == NULL )
		return '\0';
	if( idx == NULL )
		return '\0';

	if( !g_flg_play_replay )
		return '\0';

	for( ; *pp != NULL; *pp = (*pp)->next, *idx = 0 ){
		c = (*pp)->buf[*idx];
		if( c != '\0' ){
			(*idx)++;
			return c;
		}
	}

	return '\0';
}

/***************************************************************
* ץ쥤κե饰֤
* return : ե饰
***************************************************************/

bool_t	get_flg_play_replay( void )
{
	return g_flg_play_replay;
}

/***************************************************************
* ץ쥤κե饰
* bool_t flg : ե饰
***************************************************************/

void	set_flg_play_replay( bool_t flg )
{
	g_flg_play_replay = flg;

	if( flg ){
		g_replay_cur[REPLAY_SLOT_PLAY]
				= g_replay_head[REPLAY_SLOT_PLAY];
		g_replay_cur_draw
				= g_replay_head[REPLAY_SLOT_PLAY];

		if( g_replay_head[REPLAY_SLOT_PLAY] != NULL )
			g_replay_head[REPLAY_SLOT_PLAY]->n = 0;

		g_play_replay_turn = -1;
		g_play_replay_count = 0;

		g_play_replay_idx = 0;
		g_play_replay_idx_draw = 0;
	} else {
		g_play_replay_turn = -1;
		g_play_replay_count = 0;
	}
}

/***************************************************************
* ץ쥤μ ID ֤
* long n : ǡåֹ
* return : ץ쥤μ ID
***************************************************************/

char	*get_msg_replay_kind( replay_t *p )
{
	if( p == NULL )
		return "";

	switch( p->kind ){
	case REPLAY_KIND_KEY:
		return MSG_REPLAY_KIND_KEY;
		break;
	case REPLAY_KIND_GETS:
		return MSG_REPLAY_KIND_GETS;
		break;
	case REPLAY_KIND_MAX_N:
		break;
	}

	return "";
}

/***************************************************************
* ǡåֹ椫ץ쥤åֹѴ
* long n : ǡåֹ
* return : ץ쥤åֹ
***************************************************************/

replay_slot_t	cv_slot_n( long n )
{
	if( n == SAVE_N_AUTO )
		return REPLAY_SLOT_AUTO;
	else
		return REPLAY_SLOT_STD;
}

/***************************************************************
* ץ쥤μ֤
* return : ץ쥤μ
***************************************************************/

long	get_replay_randm_seed( long n )
{
	replay_slot_t	sn = cv_slot_n( n );

	return g_replay_randm_seed[sn];
}

/***************************************************************
* ץ쥤Υֹ֤
* return : ץ쥤Υֹ
***************************************************************/

long	get_replay_save_n( void )
{
	return g_replay_save_slot;
}

/***************************************************************
* ץ쥤ꥹȤƬ֤
* long n : ǡåֹ
* return : ץ쥤ꥹȤƬ
***************************************************************/

replay_t	*get_replay_head( long n )
{
	replay_slot_t	sn = cv_slot_n( n );

	return g_replay_head[sn];
}

/***************************************************************
* ץ쥤Υ꡼
* return : ꡼
***************************************************************/

replay_t	*alloc_replay( void )
{
	replay_t	*p;

	p = (replay_t *)alloc_mem( sizeof( replay_t ), FALSE );
	if( p == NULL ){
		end_reg_replay( SAVE_N_AUTO );
		end_reg_replay( g_replay_save_slot );

		return NULL;
	}

	p->next = NULL;
	p->kind = REPLAY_KIND_KEY;
	p->n = 0;
	p->buf[0] = '\0';

	return p;
}

/***************************************************************
* ץ쥤Υ꡼
* replay_t *p : ꡼
***************************************************************/

void	free_replay( replay_t *p )
{
	free_mem( p );
}
