/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: town-tab.h,v 1.9 2007/01/11 17:31:35 bowkenken Exp $
***************************************************************/

#ifndef	TOWN_TAB_H
#define	TOWN_TAB_H

/* ޥåסǡοȥ֥Ȥбɽ */

long	town_ptn_col_tab_max_n;
town_ptn_col_tab_t	town_ptn_col_tab[] = {
	{ 0xffffff, '.', ' ' },
	{ 0x00ffff, '>', 'd' },
	{ 0xff0000, '+', ' ' },
	{ 0xff0010, '+', FACE_MNR_GATE },
	{ 0xff0110, '+', FACE_MNR_SHOP_INN },
	{ 0xff0120, '+', FACE_MNR_SHOP_BAR },
	{ 0xff0130, '+', FACE_MNR_SHOP_WPN },
	{ 0xff0140, '+', FACE_MNR_SHOP_ARMOR },
	{ 0xff0150, '+', FACE_MNR_SHOP_MAGIC },
	{ 0xff0160, '+', FACE_MNR_SHOP_TEMPLE },
	{ 0xff0170, '+', FACE_MNR_SHOP_ALCHEMY },
	{ 0xff0180, '+', FACE_MNR_SHOP_MUSIC },
	{ 0xff0190, '+', FACE_MNR_SHOP_GROCERY },
	{ 0xff01a0, '+', FACE_MNR_SHOP_RESTAURANT },
	{ 0xff01b0, '+', FACE_MNR_SHOP_TEAROOM },
	{ 0xff01c0, '+', FACE_MNR_SHOP_TOBACCO },
	{ 0xff01d0, '+', FACE_MNR_SHOP_PET_SHOP },
	{ 0x808080, '#', '#' },
	{ 0x00ff41, '#', FACE_MNR_STREETLAMP },
	{ 0xffff41, '#', 'A' },
	{ 0xffff42, '#', 'B' },
	{ 0xffff43, '#', 'C' },
	{ 0xffff44, '#', 'D' },
	{ 0xffff45, '#', 'E' },
	{ 0xffff46, '#', 'F' },
	{ 0xffff47, '#', 'G' },
	{ 0xffff48, '#', 'H' },
	{ 0xffff49, '#', 'I' },
	{ 0xffff4a, '#', 'J' },
	{ 0xffff4b, '#', 'K' },
	{ 0xffff4c, '#', 'L' },
	{ 0xffff4d, '#', 'M' },
	{ 0xffff4e, '#', 'N' },
	{ 0xffff4f, '#', 'O' },
	{ 0xffff50, '#', 'P' },
	{ 0xffff51, '#', 'Q' },
	{ 0xffff52, '#', 'R' },
	{ 0xffff53, '#', 'S' },
	{ 0xffff54, '#', 'T' },
	{ 0xffff55, '#', 'U' },
	{ 0xffff56, '#', 'V' },
	{ 0xffff57, '#', 'W' },
	{ 0xffff58, '#', 'X' },
	{ 0xffff59, '#', 'Y' },
	{ 0xffff5a, '#', 'Z' },
	{ 0xffff61, '#', 'a' },
	{ 0xffff62, '#', 'b' },
	{ 0xffff63, '#', 'c' },
	{ 0xffff64, '#', 'd' },
	{ 0xffff65, '#', 'e' },
	{ 0xffff66, '#', 'f' },
	{ 0xffff67, '#', 'g' },
	{ 0xffff68, '#', 'h' },
	{ 0xffff69, '#', 'i' },
	{ 0xffff6a, '#', 'j' },
	{ 0xffff6b, '#', 'k' },
	{ 0xffff6c, '#', 'l' },
	{ 0xffff6d, '#', 'm' },
	{ 0xffff6e, '#', 'n' },
	{ 0xffff6f, '#', 'o' },
	{ 0xffff70, '#', 'p' },
	{ 0xffff71, '#', 'q' },
	{ 0xffff72, '#', 'r' },
	{ 0xffff73, '#', 's' },
	{ 0xffff74, '#', 't' },
	{ 0xffff75, '#', 'u' },
	{ 0xffff76, '#', 'v' },
	{ 0xffff77, '#', 'w' },
	{ 0xffff78, '#', 'x' },
	{ 0xffff79, '#', 'y' },
	{ 0xffff7a, '#', 'z' },
	{ 0x000000, FACE_MJR_NULL, FACE_MNR_NULL },
};

/* Źޥåסǡͭ뤫å뤿Υꥹ */

typedef struct g_shop_face_ls_t {
	char	mnr;
	bool_t	flg;
} g_shop_face_ls_t;

g_shop_face_ls_t	g_shop_face_ls[] = {
	{ FACE_MNR_SHOP_INN, FALSE },
	{ FACE_MNR_SHOP_BAR, FALSE },
	{ FACE_MNR_SHOP_WPN, FALSE },
	{ FACE_MNR_SHOP_ARMOR, FALSE },
	{ FACE_MNR_SHOP_MAGIC, FALSE },
	{ FACE_MNR_SHOP_TEMPLE, FALSE },
	{ FACE_MNR_SHOP_ALCHEMY, FALSE },
	{ FACE_MNR_SHOP_MUSIC, FALSE },
	{ FACE_MNR_SHOP_GROCERY, FALSE },
	{ FACE_MNR_SHOP_RESTAURANT, FALSE },
	{ FACE_MNR_SHOP_TEAROOM, FALSE },
	{ FACE_MNR_SHOP_TOBACCO, FALSE },
	{ FACE_MNR_SHOP_PET_SHOP, FALSE },
};

const long	g_shop_face_ls_max_n
		= sizeof( g_shop_face_ls ) / sizeof( g_shop_face_ls[0] );

/* ξʥꥹ */

typedef struct {
	item_kind_t	kind;
	long	ave_stock;
	food_kind_t	food;
	potion_kind_t	potion;
} art_ls_bar_t;

art_ls_bar_t	art_ls_bar[] = {
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_POTAGE,
		POTION_KIND_NULL },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_MILK },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_ALE },
	{ ITEM_KIND_NULL, 0, FOOD_KIND_NULL,
		POTION_KIND_NULL },
};

/* ﲰξʥꥹ */

typedef struct {
	item_kind_t	kind;
	long	ave_stock;
	wpn_kind_t	wpn;
} art_ls_wpn_t;

art_ls_wpn_t	art_ls_wpn[] = {
	{ ITEM_KIND_WPN, 4, WPN_KIND_KNIFE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_KATAR },
	{ ITEM_KIND_WPN, 4, WPN_KIND_SHORT_SWORD },
	{ ITEM_KIND_WPN, 4, WPN_KIND_LONG_SWORD },
	{ ITEM_KIND_WPN, 4, WPN_KIND_BROAD_SWORD },
	{ ITEM_KIND_WPN, 4, WPN_KIND_BASTARD_SWORD },
	{ ITEM_KIND_WPN, 4, WPN_KIND_GREAT_SWORD },
	{ ITEM_KIND_WPN, 4, WPN_KIND_HAND_AXE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_BATTLE_AXE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_BROAD_AXE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_GREAT_AXE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_WOODEN_CLUB },
	{ ITEM_KIND_WPN, 4, WPN_KIND_QUARTER_STAFF },
	{ ITEM_KIND_WPN, 4, WPN_KIND_LIGHT_FLAIL },
	{ ITEM_KIND_WPN, 4, WPN_KIND_HEAVY_FLAIL },
	{ ITEM_KIND_WPN, 4, WPN_KIND_MORNINGSTAR },
	{ ITEM_KIND_WPN, 4, WPN_KIND_LIGHT_MACE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_HEAVY_MACE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_POLEAXE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_GLAIVE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_HALBERD },
	{ ITEM_KIND_WPN, 4, WPN_KIND_BRASS_KNUCKLE },
	{ ITEM_KIND_WPN, 4, WPN_KIND_SLING },
	{ ITEM_KIND_WPN, 4, WPN_KIND_SHORT_BOW },
	{ ITEM_KIND_WPN, 4, WPN_KIND_LONG_BOW },
	{ ITEM_KIND_WPN, 4, WPN_KIND_COMPOSITE_BOW },
	{ ITEM_KIND_WPN, 4, WPN_KIND_LIGHT_CROSS_BOW },
	{ ITEM_KIND_WPN, 4, WPN_KIND_HEAVY_CROSS_BOW },
	{ ITEM_KIND_WPN, 4, WPN_KIND_BLOW_GUN },
	{ ITEM_KIND_WPN, 100, WPN_KIND_BULLET },
	{ ITEM_KIND_WPN, 100, WPN_KIND_ARW },
	{ ITEM_KIND_WPN, 100, WPN_KIND_BOLT },
	{ ITEM_KIND_WPN, 100, WPN_KIND_NEEDLE },
	{ ITEM_KIND_WPN, 100, WPN_KIND_DAGGER },
	{ ITEM_KIND_WPN, 100, WPN_KIND_DARTS },
	{ ITEM_KIND_NULL, 0, WPN_KIND_NULL },
};

/* ɶ񲰤ξʥꥹ */

typedef struct {
	item_kind_t	kind;
	long	ave_stock;
	armor_kind_t	armor;
} art_ls_armor_t;

art_ls_armor_t	art_ls_armor[] = {
	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_BUCKLER_SHIELD },
	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_ROUND_SHIELD },
	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_KITE_SHIELD },
	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_HEATER_SHIELD },

	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_LEATHER_CAP },
	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_METAL_CAP },
	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_SALLET },
	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_CLOSE_HELMET },

	{ ITEM_KIND_ARMOR, 4, ARMOR_KIND_ROBE },
	{ ITEM_KIND_ARMOR, 4, ARMOR_KIND_SOFT_LEATHER_ARMOR },
	{ ITEM_KIND_ARMOR, 4, ARMOR_KIND_HARD_LEATHER_ARMOR },
	{ ITEM_KIND_ARMOR, 4, ARMOR_KIND_RING_MAIL },
	{ ITEM_KIND_ARMOR, 4, ARMOR_KIND_SCALE_MAIL },
	{ ITEM_KIND_ARMOR, 4, ARMOR_KIND_LAMELLAR_ARMOR },
	{ ITEM_KIND_ARMOR, 4, ARMOR_KIND_CHAIN_MAIL },
	{ ITEM_KIND_ARMOR, 4, ARMOR_KIND_PLATE_ARMOR },

	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_LEATHER_GLOVES },
	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_GAUNTLETS },

	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_LEATHER_BOOTS },
	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_GREAVE },

	{ ITEM_KIND_ARMOR, 6, ARMOR_KIND_CLOAK },

	{ ITEM_KIND_NULL, 0, ARMOR_KIND_NULL },
};

/* ϣѲξʥꥹ */

typedef struct {
	item_kind_t	kind;
	long	ave_stock;
	potion_kind_t	potion;
	scroll_kind_t	scroll;
	stick_kind_t	stick;
	spell_kind_t	spell;
	ring_kind_t	ring;
	amulet_kind_t	amulet;
	necklace_kind_t	necklace;
} art_ls_alchemy_t;

art_ls_alchemy_t	art_ls_alchemy[] = {

/* potion */
	{ ITEM_KIND_POTION, 12,
		POTION_KIND_CURE_HP_LIGHT,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_CURE_HP_MODERATE,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_CURE_HP_SERIOUS,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_CURE_HP_MAX,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_CURE_LEV,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_CURE_POISON,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_CURE_STATUS,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_POW_UP_HP,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_SENSE_INVISIBLE,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_RESI_PHYS,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_RESI_HEAT,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_RESI_COLD,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_RESI_ACID,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_RESI_MIND,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_RESI_ELEC,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_RESI_POIS,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_SHARPNESS,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_STRENGTH,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_QUICKNESS,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_POTION, 12,
		POTION_KIND_SPEED_UP,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},
/* scroll */
	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_RECALL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 100,
		POTION_KIND_NULL,
		SCROLL_KIND_IDENTIFY_ITEM,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 50,
		POTION_KIND_NULL,
		SCROLL_KIND_IDENTIFY_ALL_ITEM,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_DETECT_ITEM,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_POW_UP_WPN_HIT,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_POW_UP_WPN_CRTCL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_POW_UP_WPN_DAM,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_POW_UP_ARMOR_DEF,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_POW_UP_ARMOR_CRTCL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_POW_UP_ARMOR_AC,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_PROTECT_ARMOR,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_SCROLL, 12,
		POTION_KIND_NULL,
		SCROLL_KIND_REMOVE_CURSE,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},
/* wand */
	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_TELEPORT,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_TELEPORT_PARTY,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_FIRE_BALL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_ICE_BLIZZARD,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_ACID_RAIN,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_MIND_STORM,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_LIGHTNING_BOLT,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_POISON_CLOUD,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_STONE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_PARALYZE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_POISON,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_CONFUSION,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_BLINDNESS,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_SLEEP,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_SILENCE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_FEAR,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_HALLUCINATION,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_WAND,
		SPELL_KIND_CHARM,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},
/* rod */
	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_TELEPORT,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_FIRE_BALL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_ICE_BLIZZARD,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_ACID_RAIN,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_MIND_STORM,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_LIGHTNING_BOLT,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_POISON_CLOUD,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_STONE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_PARALYZE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_POISON,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_CONFUSION,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_BLINDNESS,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_SLEEP,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_SILENCE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_FEAR,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_HALLUCINATION,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_ROD,
		SPELL_KIND_CHARM,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},
/* staff */
	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_TELEPORT,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_FIRE_BALL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_ICE_BLIZZARD,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_ACID_RAIN,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_MIND_STORM,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_LIGHTNING_BOLT,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_POISON_CLOUD,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_STONE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_PARALYZE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_POISON,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_CONFUSION,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_BLINDNESS,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_SLEEP,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_SILENCE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_FEAR,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_HALLUCINATION,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_CHARM,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_SHARPNESS,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_DULLNESS,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_STRENGTH,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_WEAKNESS,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_QUICKNESS,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_SLOWNESS,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_BRAINY,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_BRAINLESS,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_WISE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_FOOLISH,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_ATTRACTIVE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_STICK, 6,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_STAFF,
		SPELL_KIND_UNATTRACTIVE,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},
/* ring */
	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_SLOW_DIGESTION,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_TELEPORT_PARTY,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_SHARPNESS,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_STRENGTH,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_QUICKNESS,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_BRAINY,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_WISE,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_ATTRACTIVE,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},
/* amulet */
	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_DEAD,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_STONE,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_PARALYZE,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_POISON,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_CONFUSION,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_BLIND,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_SLEEP,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_SILENCE,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_FEAR,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_HALLUCINATION,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_CHARM,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_DRUNK,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_FLY,
		NECKLACE_KIND_NULL,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_VANISH,
		NECKLACE_KIND_NULL,
	},
	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_IRON_BODY,
		NECKLACE_KIND_NULL,
	},
	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_PASSWALL,
		NECKLACE_KIND_NULL,
	},
	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_RESI_STAT_SENSE_INVISIBLE,
		NECKLACE_KIND_NULL,
	},
/* necklace */
	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_RESI_PHYS,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_RESI_HEAT,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_RESI_COLD,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_RESI_ACID,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_RESI_MIND,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_RESI_ELEC,
	},

	{ ITEM_KIND_ACCE, 3,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_RESI_POIS,
	},
/* end */
	{ ITEM_KIND_NULL, 0,
		POTION_KIND_NULL,
		SCROLL_KIND_NULL,
		STICK_KIND_NULL,
		SPELL_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
	},
};

/* ڱξʥꥹ */

typedef struct {
	item_kind_t	kind;
	long	ave_stock;
	inst_kind_t	inst;
	anthology_kind_t	anthology;
} art_ls_music_t;

art_ls_music_t	art_ls_music[] = {

/*  */
	{ ITEM_KIND_ANTHOLOGY, 6,
		INST_KIND_NULL,
		ANTHOLOGY_KIND_CURE,
	},

	{ ITEM_KIND_ANTHOLOGY, 6,
		INST_KIND_NULL,
		ANTHOLOGY_KIND_STRENGTHEN_ABL,
	},

	{ ITEM_KIND_ANTHOLOGY, 6,
		INST_KIND_NULL,
		ANTHOLOGY_KIND_WEAKEN_ABL,
	},

	{ ITEM_KIND_ANTHOLOGY, 6,
		INST_KIND_NULL,
		ANTHOLOGY_KIND_RESI_STAT,
	},
/* ڴ */
	{ ITEM_KIND_INST, 6,
		INST_KIND_TRUMPET,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_TROMBONE,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_FLUGELHORN,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_CORNET,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_HORN,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_TUBA,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_SOUSAPHONE,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_BUGLE,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_FLUTE,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_CLARINET,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_BASS_CLARINET,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_PICCOLO,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_OBOE,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_BASSOON,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_SAXOPHONE,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_VIOLIN,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_VIOLA,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_CELLO,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_DOUBLEBASS,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_HARP,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_MANDOLIN,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_BANJO,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_SITAR,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_BASS_DRUM,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_TENOR_DRUM,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_SNARE_DRUM,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_TOM_TOM,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_CONGAS,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_TIMPANI,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_CYMBAL,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_GONG,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_MARACA,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_TRIANGLE,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_CASTANETS,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_TUBULAR_BELLS,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_XYLOPHONE,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_ACCORDION,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_BAGPIPE,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_HARMONICA,
		ANTHOLOGY_KIND_NULL,
	},

	{ ITEM_KIND_INST, 6,
		INST_KIND_KAZOO,
		ANTHOLOGY_KIND_NULL,
	},
/* end */
	{ ITEM_KIND_NULL, 0,
		INST_KIND_NULL,
		ANTHOLOGY_KIND_NULL,
	},
};

/* ߲ξʥꥹ */

typedef struct {
	item_kind_t	kind;
	long	ave_stock;
	potion_kind_t	potion;
	food_kind_t	food;
	tobacco_kind_t	tobacco;
	tobacco_brand_t	tobacco_brand;
	light_kind_t	light;
} art_ls_grocery_t;

art_ls_grocery_t	art_ls_grocery[] = {
/* potion */
	{ ITEM_KIND_POTION, 256,
		POTION_KIND_WATER,
		FOOD_KIND_NULL,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_NULL },

	{ ITEM_KIND_POTION, 256,
		POTION_KIND_OIL,
		FOOD_KIND_NULL,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_NULL },
/* food */
	{ ITEM_KIND_FOOD, 256,
		POTION_KIND_NULL,
		FOOD_KIND_PRESERVED,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_NULL },

	{ ITEM_KIND_FOOD, 256,
		POTION_KIND_NULL,
		FOOD_KIND_CHIPPED_BEEF,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_NULL },

	{ ITEM_KIND_FOOD, 256,
		POTION_KIND_NULL,
		FOOD_KIND_CORNED_BEEF,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_NULL },
/* tobacco */
	{ ITEM_KIND_TOBACCO, 256,
		POTION_KIND_NULL,
		FOOD_KIND_NULL,
		TOBACCO_KIND_ABSTAIN_GUM,
		TOBACCO_BRAND_NICOTIME,
		LIGHT_KIND_NULL },
/* light */
	{ ITEM_KIND_LIGHT, 32,
		POTION_KIND_NULL,
		FOOD_KIND_NULL,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_TORCH },

	{ ITEM_KIND_LIGHT, 12,
		POTION_KIND_NULL,
		FOOD_KIND_NULL,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_LANTERN },

	{ ITEM_KIND_LIGHT, 12,
		POTION_KIND_NULL,
		FOOD_KIND_NULL,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_LAMP },
/* spike */
	{ ITEM_KIND_SPIKE, 256,
		POTION_KIND_NULL,
		FOOD_KIND_NULL,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_NULL },
/* end */
	{ ITEM_KIND_NULL, 0,
		POTION_KIND_NULL,
		FOOD_KIND_NULL,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		LIGHT_KIND_NULL },
};

/* 쥹ȥξʥꥹ */

typedef struct {
	item_kind_t	kind;
	long	ave_stock;
	food_kind_t	food;
	potion_kind_t	potion;
} art_ls_restaurant_t;

art_ls_restaurant_t	art_ls_restaurant[] = {
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_BREAD,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_BROWN_BREAD,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_TOAST,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_PANCAKE,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_SALAD,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_POTATO_SALAD,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_SCRAMBLED_EGGS,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_FRIED_EGGS,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_HARD_BOILED_EGGS,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_SOFT_BOILED_EGGS,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_SAUSAGE,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_BACON,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_BEEF_STEAK,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_PORK_SAUTE,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_FRIED_CHICKEN,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_FRIED_FISH,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_FRIED_POTATO,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_STEWED_BEEF,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_CONSOMME,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_POTAGE,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_APPLE_PIE,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_APPLE,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_GRAPE,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_ORANGE,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_PEAR,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_GRAPEFRUIT,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_PLUM,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_PEACH,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_APRICOT,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_BLACK_BERRY,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_CRAN_BERRY,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_RASP_BERRY,
		POTION_KIND_NULL },
	{ ITEM_KIND_FOOD, 256, FOOD_KIND_STRAW_BERRY,
		POTION_KIND_NULL },

	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_WATER },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_MILK },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_RED_WINE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_WHITE_WINE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_ROSE_WINE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_ALE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_BRANDY },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_RUM },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_COFFE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_ICE_COFFE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_TEA },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_MILK_TEA },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_LEMON_TEA },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_ICE_TEA },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_ICE_MILK_TEA },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_ICE_LEMON_TEA },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_APPLE_JUICE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_GRAPE_JUICE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_ORANGE_JUICE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_BLACK_BERRY_JUICE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_CRAN_BERRY_JUICE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_RASP_BERRY_JUICE },
	{ ITEM_KIND_POTION, 256, FOOD_KIND_NULL,
		POTION_KIND_STRAW_BERRY_JUICE },
	{ ITEM_KIND_NULL, 0, FOOD_KIND_NULL,
		POTION_KIND_NULL },
};

/* Źξʥꥹ */

typedef struct {
	item_kind_t	kind;
	long	ave_stock;
	potion_kind_t	potion;
} art_ls_tearoom_t;

art_ls_tearoom_t	art_ls_tearoom[] = {
	{ ITEM_KIND_POTION, 256, POTION_KIND_WATER },
	{ ITEM_KIND_POTION, 256, POTION_KIND_MILK },
	{ ITEM_KIND_POTION, 256, POTION_KIND_RED_WINE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_WHITE_WINE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_ROSE_WINE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_ALE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_BRANDY },
	{ ITEM_KIND_POTION, 256, POTION_KIND_RUM },
	{ ITEM_KIND_POTION, 256, POTION_KIND_COFFE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_ICE_COFFE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_TEA },
	{ ITEM_KIND_POTION, 256, POTION_KIND_MILK_TEA },
	{ ITEM_KIND_POTION, 256, POTION_KIND_LEMON_TEA },
	{ ITEM_KIND_POTION, 256, POTION_KIND_ICE_TEA },
	{ ITEM_KIND_POTION, 256, POTION_KIND_ICE_MILK_TEA },
	{ ITEM_KIND_POTION, 256, POTION_KIND_ICE_LEMON_TEA },
	{ ITEM_KIND_POTION, 256, POTION_KIND_APPLE_JUICE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_GRAPE_JUICE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_ORANGE_JUICE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_BLACK_BERRY_JUICE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_CRAN_BERRY_JUICE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_RASP_BERRY_JUICE },
	{ ITEM_KIND_POTION, 256, POTION_KIND_STRAW_BERRY_JUICE },
	{ ITEM_KIND_NULL, 0, POTION_KIND_NULL },
};

/* 𲰤ξʥꥹ */

typedef struct {
	item_kind_t	kind;
	long	ave_stock;
	tobacco_kind_t	tobacco;
	tobacco_brand_t	tobacco_brand;
	pipe_kind_t	pipe;
} art_ls_tobacco_t;

art_ls_tobacco_t	art_ls_tobacco[] = {
	/* CIGARET */
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_HELLO,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_SUN_SHINE,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_CHERRY_TREE,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_GOLDEN_RAT,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_AIR_SHIT,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_HOP,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_PIECE,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_HARPY,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_HIGH_LIGHT,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_SHOOTING_STARS,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_WILD_NINE,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_WILD_NINE_MENTHOL,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_LODGE,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_LODGE_MENTHOL,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_CANCER,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_CANCER_MENTHOL,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_FRONT_LINE,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_FRONT_LINE_MENTHOL,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_MARCO_POLO,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_CAMELLIA,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_GOOD_LUCK,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGARET,
		TOBACCO_BRAND_BAD_GUY,
		PIPE_KIND_NULL },

	/* CIGAR */
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGAR,
		TOBACCO_BRAND_ARCADIA,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGAR,
		TOBACCO_BRAND_GLORIA,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGAR,
		TOBACCO_BRAND_VULCAN,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGAR,
		TOBACCO_BRAND_PONY,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGAR,
		TOBACCO_BRAND_KEITH,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGAR,
		TOBACCO_BRAND_LUMBERJACK,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGAR,
		TOBACCO_BRAND_CORONA,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGAR,
		TOBACCO_BRAND_HALF_CORONA,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CIGAR,
		TOBACCO_BRAND_CRYSTAL,
		PIPE_KIND_NULL },

	/* CUT TOBACCO */
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_FOREST_BRANDY,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_SILK_ROAD,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_PROMENADE,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_BIG_HORN,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_ROCKING_CHAIR,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_VANILLA,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_WILD_MANGO,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_KENTUCKY_BIRD,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_ORIENT,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CUT_TOBACCO,
		TOBACCO_BRAND_FUJI,
		PIPE_KIND_NULL },

	/* SNUFF TOBACCO */
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_SNUFF_TOBACCO,
		TOBACCO_BRAND_DOGGY_APRICOT,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_SNUFF_TOBACCO,
		TOBACCO_BRAND_DOGGY_WHISKY,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_SNUFF_TOBACCO,
		TOBACCO_BRAND_DOGGY_HONEY,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_SNUFF_TOBACCO,
		TOBACCO_BRAND_DOGGY_SPEARMINT,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_SNUFF_TOBACCO,
		TOBACCO_BRAND_DOGGY_PEPPERMINT,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_SNUFF_TOBACCO,
		TOBACCO_BRAND_DOGGY_VANILLA,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_SNUFF_TOBACCO,
		TOBACCO_BRAND_DOGGY_MENTHOL,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_SNUFF_TOBACCO,
		TOBACCO_BRAND_DOGGY_CITRUS,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_SNUFF_TOBACCO,
		TOBACCO_BRAND_DOGGY_SHERRY,
		PIPE_KIND_NULL },

	/* CHEWING TOBACCO */
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CHEWING_TOBACCO,
		TOBACCO_BRAND_ROSE_PREMIUM,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CHEWING_TOBACCO,
		TOBACCO_BRAND_ROSE_VANILLA,
		PIPE_KIND_NULL },
	{ ITEM_KIND_TOBACCO, 256,
		TOBACCO_KIND_CHEWING_TOBACCO,
		TOBACCO_BRAND_ROSE_MENTHOL,
		PIPE_KIND_NULL },

	/* PIPE */
	{ ITEM_KIND_PIPE, 16,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		PIPE_KIND_PIPE },
	{ ITEM_KIND_PIPE, 16,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		PIPE_KIND_KISEL },
	{ ITEM_KIND_PIPE, 256,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		PIPE_KIND_CIGARET_HOLDER },

	/* DISPOSAL */
	{ ITEM_KIND_DISPOSAL, 16,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		PIPE_KIND_NULL },

	/* END */
	{ ITEM_KIND_NULL, 0,
		TOBACCO_KIND_NULL,
		TOBACCO_BRAND_NULL,
		PIPE_KIND_NULL },
};

/* ڥåȡåפξʥꥹ */

art_ls_pet_shop_t	art_ls_pet_shop[] = {
	{ MNSTR_KIND_CAT,
		(gold_t)500, },
	{ MNSTR_KIND_DOG,
		(gold_t)500, },
	{ MNSTR_KIND_PYON_PYON,
		(gold_t)1000, },
	{ MNSTR_KIND_NULL,
		(gold_t)0, },
};

#endif	/* TOWN_TAB_H */
