#!/bin/bash
# LKST patch-porting helper script
# COPYRIGHT (C) HITACHI,LTD. 2003 ALL RIGHTS RESERVED.
# Written by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
# Usage: scripts/porting.sh <linux tarball(linux-xxx.tar.bz2/tar.gz)>

WORKDIR=porting
CUR_VER=2.6.0
CUR_SHVER=`echo $CUR_VER | tr -d . `

[ -d $WORKDIR ] && echo "$WORKDIR already exists, abort." && exit 1
mkdir $WORKDIR
[ -d $WORKDIR ] || exit 0;

WORKDIR=`cd $WORKDIR && pwd`

KTARBZ=$1
[ $# -ne 1 ] && exit 1
KDIR=`basename $KTARBZ | sed -e s/.tar.bz2$//g -e s/.tar.gz$//g`
KVER=`echo $KDIR | sed -e s/^linux-//g`
KSHVER=`echo $KVER | tr -d . `

echo KVER = $KVER
echo KSHVER = $KSHVER

[ -z "$EDITOR" ] && EDITOR=vi

function porting () {
SDIR=$WORKDIR/$1
DDIR=$WORKDIR/$2
SPATCH=$3
DPATCH=$4
[ -z "$DPATCH" ] && DPATCH=`basename $SPATCH`
mkdir $DDIR || rm -rf $DDIR/*
lndir -silent $SDIR $DDIR
patch -p1 -d $DDIR < $SPATCH &> $DDIR/patch.log
[ `grep -v ^patching $DDIR/patch.log| wc -l` -ne 0 ] && ( echo "automatic porting might fail, please fix that"; $EDITOR $DDIR/patch.log )
echo "----"Making $DPATCH... >> $WORKDIR/patch-all.log
cat $DDIR/patch.log >> $WORKDIR/patch-all.log
rm `find $DDIR -name \*~ -o -name \*.orig -o -name \*.rej` $DDIR/patch.log
( cd $WORKDIR ; \
  diff -Naru $1 $2 > $WORKDIR/$DPATCH )
}

echo "Infrating"
rm -rf $WORKDIR/*
if [ -z `echo $KTARBZ | grep *.gz` ] ; then
	tar xjf $KTARBZ -C $WORKDIR
else
	tar xzf $KTARBZ -C $WORKDIR
fi

echo "Porting kernelhooks base patch"
porting $KDIR linux-hooks-base \
	./hooks/kernelhooks-v1.8-$CUR_SHVER-base.patch \
	kernelhooks-v1.8-$KSHVER-base.patch

echo "Porting kernelhooks fix kconfig patch"
porting linux-hooks-base linux-hooks-fix_conf \
	./hooks/kernelhooks-v1.8-fix_kconfig.patch

echo "Porting kernelhooks fix makefile patch"
porting linux-hooks-fix_conf linux-hooks-fix_make \
	./hooks/kernelhooks-v1.8-fix_kmakefile.patch

echo "Porting kernelhooks resolve dependency patch"
porting linux-hooks-fix_make linux-hooks-resolve \
	./hooks/kernelhooks-v1.8-resolve_dependency.patch

echo "Porting kernelhooks ia64 support patch"
porting linux-hooks-resolve linux-hooks-ia64 \
	./hooks/kernelhooks-v1.8-support_ia64.patch

echo "Porting preassigned patch"
porting $KDIR linux-preassigned \
	./extra-patch/preassigned-$CUR_VER.patch \
	preassigned-$KVER.patch

echo "Preparing hooks "
SDIR=$WORKDIR/linux-preassigned
DDIR=$WORKDIR/linux-hooks
mkdir $DDIR || rm -rf $DDIR/*
lndir -silent $SDIR $DDIR
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-$KSHVER-base.patch > $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-fix_kconfig.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-fix_kmakefile.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-resolve_dependency.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-support_ia64.patch >> $WORKDIR/patch.log
rm `find $DDIR -name \*~ -o -name \*.orig -o -name \*.rej` &> /dev/null

echo "Porting LKST patch"
porting linux-hooks linux-lkst ./linux26.patch

echo "Porting vmsync patch"
porting $KDIR linux-vmsync \
	./extra-patch/vmsync-$CUR_VER.patch \
	vmsync-$KVER.patch

echo "Preparing hooks "
SDIR=$WORKDIR/linux-vmsync
DDIR=$WORKDIR/linux-lkst-orig
mkdir $DDIR || rm -rf $DDIR/*
lndir -silent $SDIR $DDIR
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-$KSHVER-base.patch > $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-fix_kconfig.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-fix_kmakefile.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-resolve_dependency.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-support_ia64.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/linux26.patch >> $WORKDIR/patch.log
rm `find $DDIR -name \*~ -o -name \*.orig -o -name \*.rej` &> /dev/null

echo "Porting LKST patch"
porting linux-lkst-orig linux-lkst-vmsync extra-patch/lkst-use_vmsync.patch

echo "Ported"
