/*-*-c++-*-
 * $Id: cconfigmanager.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CCONFIGMANAGER_H
#define CCONFIGMANAGER_H

#ifndef WIN32
# ifndef _GNU_SOURCE
#  define _GNU_SOURCE
# endif
#endif

#include <qobject.h>
#include <qstring.h>
#include "osdep.h"
#include <map> // STL

// On Windows, we use the a hierarchy below
// the following registry path:
#ifdef WIN32
#define MY_KEYROOT HKEY_CURRENT_USER
#define MY_KEYHOME "Software\\GNU\\QLcrash"
#endif

using namespace std;

/* Configure groups */
#define CFG_GRP_CONSOLE				"Console"
#define CFG_GRP_FILES				"Files"
#define CFG_GRP_GRAPH				"Graph"
#define CFG_GRP_DUMP				"Dump"
#define CFG_GRP_TOOLBAR				"Toolbar"
#define CFG_GRP_APP					"Application"
#define CFG_GRP_PLUGIN				"Plugin"

/* Configure attributes */
#define CFG_ATT_CONSOLE_FONTFAMILY	"fontfamily"
#define CFG_ATT_CONSOLE_FONTSIZE	"fontsize"
#define CFG_ATT_FILES_LCRASH		"lcrash"
#define CFG_ATT_GRAPH_PRINTFORMAT	"printformat"
#define CFG_ATT_DUMP_TBDOCKMAIN		"toolbar_dockmain"
#define CFG_ATT_TOOLBAR_MAIN		"mainbar"
#define CFG_ATT_TOOLBAR_MAINEDGE	"main_dock"
#define CFG_ATT_TOOLBAR_MAINNL		"main_nl"
#define CFG_ATT_TOOLBAR_MAININDEX	"main_index"
#define CFG_ATT_TOOLBAR_MAINEXTRA	"main_extra_offset"
#define CFG_ATT_TOOLBAR_STATUS		"statusbar"
#define CFG_ATT_TOOLBAR_CHILD		"childbar"
#define CFG_ATT_TOOLBAR_CHILDEDGE	"child_dock"
#define CFG_ATT_TOOLBAR_CHILDNL		"child_nl"
#define CFG_ATT_TOOLBAR_CHILDINDEX	"child_index"
#define CFG_ATT_TOOLBAR_CHILDEXTRA	"child_extra_offset"
#define CFG_ATT_APP_FONTFAMILY		"fontfamily"
#define CFG_ATT_APP_FONTSIZE		"fontsize"
#define CFG_ATT_FILES_PLUGIN		"currentplugin"


/**
  *@author Michael Geselbracht
  */

class CConfigManager : QObject {
public: 
	CConfigManager(QObject* parent, const char* name=0);
	~CConfigManager();
	
	/* set the name of the configuration file */
	bool setFile(const QString& fname);
	
	/* save current configuration to config file */
	bool saveConfig();
	
	inline QString file() const {
		return oFile;
	}
	
	void setItem(const QString& category, const QString& name, const QString& value);
	void setItem(const QString& category, const QString& name, int value);
	
	QString item(const QString& category, const QString& name, const QString& def) const;
	int item(const QString& category, const QString& name, int def) const;
	
	QString homeDir() const;
	
	void clear();
	
private:
	QString oFile;
	map<QString, map<QString, QString>* > oMap;
};

#endif
