.TH lkstbuf 8
.SH NAME
lkstbuf \- Control kernel event buffer in LKST.
.br
.SH SYNOPSIS
lkstbuf \fIcommand\fR [ \fIoption(s)\fR ]
.SH DESCRIPTION
This command controls kernel event buffer in LKST such as creation, delettion, changing, and displaying a list of all buffers.
.SH COMMANDS
.TP
\fBshift \fR[\fB\-c \fIcpu_id\fR]
Change currently selected buffer to next buffer.
.TP 1i
.B \ \ \ \ \ \ \-c \fIcpu_id
Specify an id of a CPU of which buffer is changed. If omitted, buffer
of all CPUs is changed. The id must be same as described in
"\fI/proc/cpuinfo\fR".
.PP

.TP
\fBcreate \fR[\fB\-b \fIbuffer_id\fR] [\fB-c \fIcpu_id\fR] \fB-s \fIsize
Create a new kernel event buffer.
.TP 1i
.B \ \ \ \ \ \ \-b \fIbuffer_id
Specify an id of a buffer to be created. If omitted, the empty id is
selected automatically.
.PP
.TP 1i
.B \ \ \ \ \ \ \-c \fIcpu_id
Specify an id of a CPU of which the buffer is created. The id must be
same as described in "/proc/cpuinfo". If omitted, new buffers are
created for all CPUs. In this case, specified \fIbuffer_id\fR is ignored.
.PP
.TP 1i
.B \ \ \ \ \ \ \-s \fIsize
Specify a size of the buffer in byte.
.PP
.TP
\fBdelete/del \fB\-b \fIbuffer_id
Delete a kernel event buffer.
.TP 1i
.B \ \ \ \ \ \ \-b \fIbuffer_id
Specify an id of a buffer to be deleted.
.PP
.TP 1i
.B \ \ \ \ \ \ list/ls
Output a list of all kernel event buffers.
.PP

.TP 
\fBread \fR[\fB\-b \fIbuffer_id\fR] [\fB-f \fIoutput_file\fR] [\fB-n \fInumber\fR]
Read a content of kernel event buffer(s).
.TP 1i
.B \ \ \ \ \ \-b \fIbuffer_id
Specify an id of a buffer to be read. If omitted, all buffer is read.
.PP
.TP 1i
.B \ \ \ \ \ \-f \fIoutput_file
Specify an name of output file. If omitted, this command displays the
content.
.PP
.TP 1i
.B \ \ \ \ \ \-n \fInumber
Specify the number of read entry of the buffer. If omitted, all entries
of the buffer are read.
.PP

.TP
\fBprint \fR[\fB\-b \fIbuffer_id\fR | \fB\-f \fIinput_file\fR] [\fB\-c \fIcpu_id\fR] \fR[\fB\-e \fIevent_name ...\fR] [\fB\-h\fR] [\fB-n \fIentry_num\fR] [\fB-r\fR]
Display LKST trace data.
.TP 1i
.B \ \ \ \ \ \-b \fIbuffer_id
Specify an id of a buffer to be read. If omitted, all buffer is read.
.PP
.TP 1i
.B \ \ \ \ \ \-f \fIinput_file
Specify the file name of binary trace data, which is created by using lkstbuf read or lkstlogd.
(Also use kerenl crash dump file by using LKCD.)
If omitted, kernel buffer is read directly.
.PP
.TP 1i
.B \ \ \ \ \ \-c \fIcpu_id
Specify the cpu number.
.PP
.TP 1i
.B \ \ \ \ \ \-e \fIevent_name ...
Specify event filter.
Enumerate the names of events which you want to trace.
( Event name list is displayed by option \fB\-h\fR. )
Each event is separated by comma.

example(1) Display only "\fBsystem_call_entry\fR" and "\fBsystem_call_exit\fR".

.B \-e system_call_entry,system_call_exit


If you don't want to trace some events, specify "\fB!\fR" followed by the
names of the events, like "\fB!system_call_entry\fR". 
You can specify "\fBall\fR" to specify all events.

example(2) Display all events except for "\fBsystem_call_entry\fR"
and "\fBsystem_call_exit\fR".

.B \-e all,!system_call_entry,!system_call_exit


.B NOTE:
Enumerated event name is evaluated from the left to the right.
If both display and non\-display are specified for the same
event, the specification of the right side is given to priority.

.B \-e all,!spin_lock
=> display all events except spin_lock
.br
.B \-e !spin_lock,all
=> display all events
.br
.B \-e !spin_lock,spin_lock
=> the same as "\fB-e spin_lock\fR"
.br
.B \-e spin_lock,!spin_lock
=> the same as "\fB-e !spin_lock\fR"
.PP
.TP 1i
.B \ \ \ \ \ \-h
Display command help.
( Also event name list is displayed. )
.PP
.TP 1i
.B \ \ \ \ \ \-n \fIentry_num
Specify the number of output entry.
.PP
.TP 1i
.B \ \ \ \ \ \-r
Reverse the order of output record.
.br
(default : time descending sort)
.PP

.TP
\fBversion/ver
Print version information.
.PP
.TP
\fBhelp
Print help message.
.PP

.SH RETURN VALUE
.TP
.B 0
success
.TP
.B Except 0
failure
.SH REFERENCES
.BR lkst (8),
.BR ioctl(LKST_IOC_BUFFER_READ) (2),
.BR ioctl(LKST_IOC_BUFFER_LIST) (2),
.BR ioctl(LKST_IOC_BUFFER_XCHG) (2),
.BR ioctl(LKST_IOC_BUFFER_CREATE) (2),
.BR ioctl(LKST_IOC_BUFFER_DELETE) (2)
