/* $Id: buffer.h,v 1.1 2002/06/28 12:33:16 indoh Exp $ */
/* linux/include/command/buffer.h */

/************************************************************
 *
 * COPYRIGHT (C) FUJITSU,LTD. 2001 ALL RIGHTS RESERVED. 
 *
 ************************************************************/

#ifdef _LINUX_BUFFER_H

/* event data index */
#define LKST_EDATA_NAME   0
#define LKST_EDATA_FILTER 1
#define LKST_EDATA_ARG1   2
#define LKST_EDATA_ARG2   3
#define LKST_EDATA_ARG3   4
#define LKST_EDATA_ARG4   5
#define LKST_EDATA_ID_MIN 0x01
#define LKST_EDATA_ID_MAX 0x0ffe

#define LKST_STRUCT_MAX 0x0ffe + 0xffe

/* Prototype declaration */
signed long cfnc_ascending(const void *pointer1, const void *pointer2);
signed long cfnc_descending(const void *pointer1, const void *pointer2);
void help_viewer(char*);
void clock_viewer(unsigned long, unsigned long);

/* argument to function"command_analyze" */
struct lkst_arg_command_analyze {
	char* program_name;                     /* name of Execution file             */
	int   arg_filter_flag;                  /* 1=(-e option published) or 0=(not) */
	char  event_work[255];                  /* work array                         */
};

/* argument to function"buffer_save" */
struct lkst_arg_buffer_save {
	lkst_buffer_id         id;
	struct lkst_log_record *startpoint;
	int                    malloc_size;
};

/* argument to function"get_filedata" */
struct lkst_arg_get_filedata {
	char*                  program_name;    /* name of Execution file             */
	int                    arg_entry_num;   /* output entry number                */
	char*                  arg_inputfile;   /* name of reading file               */
	int                    read_entry_num;  /* number of events                   */
	unsigned long          *fdata;
	struct lkst_log_record **evr;
};

/* argument to function"make_pointerarray" */
struct lkst_arg_make_pointerarray {
	char*                  program_name;    /* name of Execution file             */
	int                    arg_entry_num;   /* output entry number                */
	int                    read_entry_num;  /* number of events                   */
	unsigned long          *fdata;
	struct lkst_log_record **evr;
	int                    malloc_size;
};

/* argument to function"sort_data" */
struct lkst_arg_sort_data {
	int                    arg_sort_flag;   /* 1=(-e option published) or 0=(not) */
	int                    read_entry_num;  /* number of events                   */
	unsigned long          *fdata;
	struct lkst_log_record **evr;
};

/* argument to function"print_data" */
struct lkst_arg_print_data {
	int                    arg_entry_num;   /* output entry number                */
	int                    arg_cpu_id;      /* cpu_id                             */
	int                    arg_filter_flag; /* 1=(-e option published) or 0=(not) */
	struct lkst_log_record **evr;
	unsigned long          *fdata;
};

/* constants */
#define LKST_LOG_FMT_RET_CODE_TRUE   0
#define LKST_LOG_FMT_RET_CODE_FALSE -1           /* return number                      */
#define LKST_MAGIC_CODE              0x76758384  /* masic number                       */
#define LKST_LOG_FMT_FILE_OPEM_MODE  "rb"        /* file offset                        */
#define LKST_LOG_FMT_SORT_BUF_SIZE   256         /* work                               */
#define LKST_LOG_FMT_PRINT_SIZE      1900        /* The definition for a total years   */

#endif    /* _LINUX_BUFFER_H */

/* END */
