/* $Id: lkst_mod_panicdump.c,v 1.2 2002/03/27 17:36:27 serizawa Exp $ */
/* testtools/lkst_mod_panicdump.c */

/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2002 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by K.SERIZAWA <serizawa@sdl.hitachi.co.jp>
 *
 ************************************************************/

/* includes */
#include<linux/version.h>
#include<linux/module.h>
#include<linux/init.h>
#include<linux/fs.h>
#include<linux/string.h>	/* for memset() */
#include <linux/sched.h>
#include<linux/lkst_private.h>

/* defines */

#define LKST_EVHANDLER_ID_PANICDUMP 0x80

/* typedef, structs */

/* externals */

/* macros */

/* globals */

static lkst_maskset_id maskset_id_new = LKST_MASKSET_ID_RNOTHING;
static lkst_maskset_id maskset_id_orig = LKST_MASKSET_ID_RNOTHING;
static lkst_maskset_id maskset_id_base = LKST_MASKSET_ID_VOID;
static struct lkst_maskset_param	maskset_param;
static struct lkst_maskset_body 	body;

/* forward declarations */

static int	lkst_mod_init(void);
static void	lkst_mod_cleanup(void);

/* module init/cleanup */

module_init(lkst_mod_init);
module_exit(lkst_mod_cleanup);

MODULE_AUTHOR("K. Serizawa <serizawa@sdl.hitachi.co.jp>");
MODULE_DESCRIPTION("LKST module to dump current buffers in panic().");
MODULE_PARM(maskset_id_base, "i");
MODULE_PARM_DESC(maskset_id_base, "ID of a maskset used as a template.");
MODULE_LICENSE("GPL");

/* inline functions */

/* functions */

void lkst_evhandler_panicdump(void *phookrec, 
			      int event_type,
				lkst_arg_t arg1,
				lkst_arg_t arg2,
				lkst_arg_t arg3,
				lkst_arg_t arg4)
{
	lkst_buffer_dump_current_txt();
}

int lkst_evhandler_test_ctrl(void *buf, size_t bufsize)
{
	if ((buf)&&(strncmp(buf, "panic", 5) == 0))
		panic("LKST PANIC TEST");
	return (0);
}

static int lkst_mod_init()
{
	int	retval;
	int	i;

	/* Register an event handler for panic dump. */
	retval = lkst_evhandler_register(LKST_EVHANDLER_ID_PANICDUMP,
					 "lkst_evhandler_panicdump",
					 &lkst_evhandler_panicdump,
					 &lkst_evhandler_test_ctrl);
	if (retval) {
		printk(KERN_ERR "cannot register event-handler function!\n");
		return (retval);
	}

	/* Initialize Maskset */
	body.len = LKST_MASKSET_TABLE_LEN_MAX;
				/* This ID can be defined as 
				   a module parameter. */
	maskset_param.id = maskset_id_base;
	maskset_param.maskset_size = LKST_MASKSET_SIZE(body.len);
	maskset_param.maskset = &body;

	/* copy from template. */
	if ((retval = lkst_maskset_read(&maskset_param)))
		return(retval);

	for (i = 0; i < body.len; i++) {
		if (body.entry[i].event_type == LKST_ETYPE_O_PANIC ) {
				/* replace handler */
			body.entry[i].id = LKST_EVHANDLER_ID_PANICDUMP;
		}
	}
	strcpy(body.name, "maskset_panicdump");
	
	/* Write new maskset */
	maskset_param.id = LKST_MASKSET_ID_VOID;
	if ((retval = lkst_maskset_write(&maskset_param))) {
		lkst_mod_cleanup();
		return(retval);
	}
	maskset_id_new = maskset_param.id;

	/* Switch to the maskset. */
	maskset_id_orig = maskset_id_new;
	if ((retval = lkst_maskset_xchg(&maskset_id_orig))) {
		lkst_mod_cleanup();
		return(retval);
	}

	return (0);
}

static void lkst_mod_cleanup()
{
  		/* Switch to saved maskset. */
	if (maskset_id_orig != maskset_id_new)
		lkst_maskset_xchg(&maskset_id_orig);

		/* deregister the event handler. */
	lkst_evhandler_register((lkst_evhandler_id) LKST_EVHANDLER_ID_PANICDUMP,
					  "", NULL, NULL);

	/* Clean up maskset */
	lkst_maskset_delete(maskset_id_new);

	return;
}

/* END */
