/*-*-c++-*-
 * $Id: structviewitem.cpp,v 1.2 2002/04/19 15:24:17 felfert Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "structviewitem.h"
#include "struct.xpm"
#include "array.xpm"
#include "scalar.xpm"
#include "pointer.xpm"

#include <qpixmap.h>
#include <qstyle.h>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

StructViewItem::StructViewItem(QListView *parent) : QListViewItem(parent)
{
	init();
}

StructViewItem::StructViewItem(QListViewItem* parent) : QListViewItem(parent)
{
	init();
}

StructViewItem::StructViewItem(QListViewItem* parent, QListViewItem* after) : QListViewItem(parent, after)
{
	init();
}

StructViewItem::~StructViewItem()
{
}

void
StructViewItem::init()
{
	oMarkedColumn = 0;
}

void
StructViewItem::setPixmapType(NodeType t)
{
	switch (t) {
		case Null:
			setPixmap(0, QPixmap());
			break;
		case Struct:
			setPixmap(0, QPixmap(struct_xpm));
			break;
		case Scalar:
			setPixmap(0, QPixmap(scalar_xpm));
			break;
		case Array:
			setPixmap(0, QPixmap(array_xpm));
			break;
		case ArrayStruct:
			setPixmap(0, QPixmap(struct_xpm));
			break;
		case Pointer:
			setPixmap(0, QPixmap(pointer_xpm));
			break;
	}
}

void
StructViewItem::paintFocus(QPainter* p, const QColorGroup& cg, const QRect& r)
{
#if (QT_VERSION < 300)
	QRect nr = r;
	
	if (isSelected()) {
		for (int i = 0; i < oMarkedColumn; i++) {
			nr.setX(nr.x() + listView()->columnWidth(i));
		}
		nr.setWidth(listView()->columnWidth(oMarkedColumn));
		
		// the first col does not have the full columnWidth()
		if (nr.x() > r.x()) {
			nr.setX(nr.x() - r.x());
		}
		
		nr.setWidth(nr.width() - r.x());
	}
	
	listView()->style().drawFocusRect(p, nr, cg, isSelected() ? &cg.highlight() : &cg.base(), isSelected());
#endif
}

