/*-*-c++-*-
 * $Id: ctreeview.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "ctreeview.h"

#include "cwalknavigator.h"
#include <qlistview.h>

CTreeView::CTreeView(QWidget *parent, const char *name )
	: QWidget(parent, name)
	, oListView(0)
{
	oNavigator = new CWalkNavigator(this);
	oNavigator->hide();
}

CTreeView::~CTreeView()
{
}

void
CTreeView::resizeEvent(QResizeEvent*)
{
	if (oListView != 0) {
		if (oNavigator->isHidden()) {
			oListView->setGeometry(0, 0, width(), height());
		}
		else {
			oListView->setGeometry(0, 0, width(), height() - oNavigator->height());
			oNavigator->setGeometry(0, oListView->y() + oListView->height(), width(), 10);
		}
	}
}

void
CTreeView::setTree(QListView* tree)
{
	delete oListView;
	oListView = tree;
	QPoint pos;
	tree->reparent(this, pos, true);
	setMinimumSize(tree->minimumSize());
	
	oNavigator->hide();
	resizeEvent(0);
}

void
CTreeView::showNavigator(bool w)
{
	if (w == oNavigator->isHidden()) {
		if (w) {
			oNavigator->show();
		}
		else {
			oNavigator->hide();
		}
		
		resizeEvent(0);
	}
}

QString
CTreeView::rootName() const
{
	return oListView->firstChild()->text(0);
}

QString
CTreeView::rootValue() const
{
	return oListView->firstChild()->text(1);
}
