/*
 * include/asm-s390/vmdump.h
 *
 * Kernel header file for Linux crash dumps.
 *
 * S390 version
 *   Copyright (C) 2001 IBM Deutschland Entwicklung GmbH,
 *                      IBM Corporation
 *
 * Derived from include/asm-i386/vmdump.h
 *   Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */

/* This header file holds the architecture specific crash dump header */
#ifndef _ASM_VMDUMP_H
#define _ASM_VMDUMP_H

/* necessary header files */
#include <asm/ptrace.h>                          /* for pt_regs             */

/* definitions */

#define DUMP_ASM_MAGIC_NUMBER     0xdeaddeadULL  /* magic number            */
#define DUMP_ASM_VERSION_NUMBER   0x1            /* version number          */

/*
 * Structure: s390_dump_header_t
 *  Function: This is the header dumped at the top of every valid s390 crash
 *            dump created with ipldump.boot .
 */

typedef struct _s390_dump_header_s {
        /* the dump magic number -- unique to verify dump is valid */
        uint64_t             dh_magic_number;

        /* the version number of this dump */
        uint32_t             dh_version;

        /* the size of this header (in case we can't read it) */
        uint32_t             dh_header_size;

        /* the level of this dump (just a header?) */
        uint32_t             dh_dump_level;

        /* the size of a Linux memory page (4K, 8K, 16K, etc.) */
        uint32_t             dh_page_size;

        /* the size of all physical memory */
        uint64_t             dh_memory_size;

        /* the start of physical memory */
        uint64_t             dh_memory_start;

        /* the end of physical memory */
        uint64_t             dh_memory_end;

        /* the number of pages in this dump specifically */
        uint32_t             dh_num_pages;

        /* ensure that dh_tod and dh_cpu_id are 8 byte aligned */
        uint32_t             dh_pad;

        /* the time of the dump generation */
        uint64_t             dh_tod;

        /* cpu id */
        uint64_t             dh_cpu_id;
} __attribute__((packed))  s390_dump_header_t;


/*
 * Structure: dump_header_asm_t
 *  Function: This is the header for architecture-specific stuff.  It
 *            follows right after the dump header.
 */
typedef struct _dump_header_asm_s {

        /* the dump magic number -- unique to verify dump is valid */
        uint64_t             dha_magic_number;

        /* the version number of this dump */
        uint32_t             dha_version;

        /* the size of this header (in case we can't read it) */
        uint32_t             dha_header_size;

	/* the esp for i386 systems */
	uint32_t             dha_esp;

	/* the eip for i386 systems */
	uint32_t             dha_eip;

	/* the dump registers */
	struct pt_regs       dha_regs;

} dump_header_asm_t;

#ifdef __KERNEL__
extern void __dump_open(struct file *, uint64_t);
extern void __dump_init(uint64_t);
extern int __dump_configure_header(dump_header_asm_t *, struct pt_regs *);
#endif

#endif /* _ASM_VMDUMP_H */
