%define name lkcdutils
%define version 4.1
%define release 1
%define revision lkst

Name: %{name}
Summary: Linux Kernel Crash Dump (LKCD) Utilities
Version: %{version}
Release: %{release}%{revision}
Copyright: GPL
Group: Utilities/System
Source: %{name}-%{version}-1.tar.gz
Patch: lkcdutils-4.1-fix-ia64.patch
URL: http://oss.sgi.com/projects/lkcd/
BuildRoot: %{_tmppath}/%{name}-root/
#Original Packager: Matt Robinson <yakker@alacritech.com>
Packager: Masami Hiramatsu <hiramatu@sdl.hitachi.co.jp>

%description
This software package contains system crash dump analyzer tools.
It includes Linux Crash (lcrash) and all appropriate user level
scripts required for saving and configuring system crash dumps.
This package should be installed after the lkcd kernel patches are
installed on the system.

%package source
Summary: The source code for %{name}-%{version}.
Group: Utilities/System

%description source
This software package includes all source code for any programs
and scripts required to support system crash dumps on a Linux
machine.

%prep
/bin/rm -r -f $RPM_BUILD_ROOT
%setup
%patch -p1 
%build
./configure --prefix=/usr --mandir=/usr/share/man
make

%install
make ROOT=$RPM_BUILD_ROOT install
mv $RPM_BUILD_ROOT/usr/man $RPM_BUILD_ROOT/usr/share/

%files
%defattr(-, root, root)
/sbin/lcrash
/sbin/lkcd
/sbin/lkcd_ksyms
/sbin/lkcd_config
%dir /usr/include/lkcd
%dir /usr/lib/lkcd
/usr/include/lkcd/*
/usr/lib/lkcd/*
/usr/share/man/man1/*
/etc/sysconfig/dump
%ifarch i386 i486 i586 i686 athlon
/usr/share/sial/lcrash
/usr/lib/libsial.a
/usr/include/sial_api.h
/usr/include/sial.h
%endif
