/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2003 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by M. Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 * 
 * record events to one buffer. (don't jump/shift)
 *
 ************************************************************/

#include<linux/version.h>
#include<linux/module.h>
#include<linux/init.h>
#include<linux/fs.h>
#include <linux/sched.h>
#include<linux/lkst_private.h>

static int	evhandler_id = LKST_EVHANDLER_ID_VOID;
static lkst_buffer_id buffer_id = LKST_BUFFER_ID_VOID;

static int	lkst_mod_init(void);
static void	lkst_mod_cleanup(void);

module_init(lkst_mod_init);
module_exit(lkst_mod_cleanup);

MODULE_AUTHOR("M. Hiramatsu <hiramatu@sdl.hitachi.co.jp>");
MODULE_DESCRIPTION("LKST module event record handler without jump/shift.");
MODULE_LICENSE("GPL");

MODULE_PARM(buffer_id, "i");
MODULE_PARM_DESC(buffer_id, "id of buffer to record.");
MODULE_PARM(evhandler_id, "i");
MODULE_PARM_DESC(evhandler_id, "id of event-hanlder to regist.");

static void lkst_evhandler_logone(void *phookrec, int event_type,
				  lkst_arg_t arg1, lkst_arg_t arg2,
				  lkst_arg_t arg3, lkst_arg_t arg4)
{
	struct lkst_event_buffer *buffer;
	int pos, flags;
	int baseid;
	if (buffer_id == LKST_BUFFER_ID_VOID || 
	    ! LKST_BUFFER_LOAD(buffer_id, buffer)) return ;

	local_irq_save(flags);/* local irq disabling for atomicity */
	/* get a entry position */ {
		baseid = buffer->baseid++;
	}
	/* adjust the entry position */
	if ( (pos = baseid - buffer->write_offset) >= buffer->size ) {
		pos %= buffer->size;
	}
	/* logging */ {
		register struct lkst_event_record * event_entry_p = 
			&(LKST_BUFFER_BODY(buffer)[pos]);
		event_entry_p->log_recid = baseid;
		event_entry_p->log_time = lkst_evhandlerprim_mc();
		event_entry_p->log_event_type = event_type;
		event_entry_p->log_pid = current->pid; /* current pid */ ;
		event_entry_p->log_arg1 = arg1;
		event_entry_p->log_arg2 = arg2;
		event_entry_p->log_arg3 = arg3;
		event_entry_p->log_arg4 = arg4;
	}
	/* Check buffer wrapping. */
	if ( pos == 0 ) {
		/* notify current writing buffer overflowed, 
		 * occurs LKST_ETYPE_LKST_BUFF_OVFLOW event, and 
		 * set reading process to ready to read. */
		buffer->write_offset += buffer->size;
	}
	local_irq_restore(flags);
}

static int lkst_evhandler_logone_ctrl(void *buf, size_t bufsize)
{
	int v = -1;
	if (buf != NULL) 
		v = simple_strtol((char *) buf, NULL, 0); /* set logging buffer */
	if ( ( v >= 0 && v <= LKST_BUFFER_ID_MAX ) || 
	     v == LKST_BUFFER_ID_VOID ) {
		buffer_id = (lkst_buffer_id ) v;
		return 0;
	} else
		return -EINVAL;
}

static int lkst_mod_init()
{
	int	retval;

	/* Register an event handler for light logging. */
	retval = lkst_evhandler_register(evhandler_id,
					 "LOG_ONEBUFFER",
					 &lkst_evhandler_logone,
					 &lkst_evhandler_logone_ctrl);
	if (retval < 0) {
		printk(KERN_ERR "cannot register event-handler function!\n");
		return retval;
	}
	evhandler_id = (lkst_evhandler_id) retval;

	return 0;
}

static void lkst_mod_cleanup()
{
	/* deregister the event handler. */
	if (evhandler_id != LKST_EVHANDLER_ID_VOID)
		lkst_evhandler_unregister((lkst_evhandler_id)evhandler_id);

	return;
}

