/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2002 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by K.HATASAKI <keisukeh@crl.hitachi.co.jp>
 *
 ************************************************************/

#include<linux/version.h>
#include<linux/module.h>
#include<linux/init.h>
#include<linux/fs.h>
#include<linux/string.h>/* for memset() */
#include <linux/sched.h>
#include <linux/kernel.h>
#include<linux/lkst_private.h>

static long record_pid = -1;
static lkst_evhandler_id evhandler_id = LKST_EVHANDLER_ID_VOID;

static int lkst_mod_init(void);
static void lkst_mod_cleanup(void);

module_init(lkst_mod_init);
module_exit(lkst_mod_cleanup);

MODULE_AUTHOR("K.Hatasaki <keisukeh@crl.hitachi.co.jp>");
MODULE_DESCRIPTION("LKST module to recoeds only specified process.");
MODULE_LICENSE("GPL");

MODULE_PARM(evhandler_id, "i");
MODULE_PARM_DESC(evhandler_id, "id of event-hanlder to regist.");

void lkst_evhandler_rec_selected_proc(void *phookrec, 
				      int event_type,
				      lkst_arg_t arg1,
				      lkst_arg_t arg2,
				      lkst_arg_t arg3,
				      lkst_arg_t arg4)
{
	if (current->pid == (pid_t) record_pid ||
	    record_pid < 0) /* select record process id */
		lkst_evhandlerprim_entry_log_l2(event_type,
						arg1, arg2, arg3, arg4);
}

int lkst_evhandler_rec_selected_proc_ctrl(void *buf, size_t bufsize)
{
	if (buf != NULL)
		record_pid = simple_strtol((char *) buf, NULL, 0); /* set record process id */
	printk("New recording process ID=%ld\n", record_pid);
	return (0);
}

static int lkst_mod_init()
{
	int retval;
	
	/* Register an event handler for panic dump. */
	retval = lkst_evhandler_register(evhandler_id,
					 "rec_selected_proc",
					 &lkst_evhandler_rec_selected_proc,
					 &lkst_evhandler_rec_selected_proc_ctrl);
	if (retval < 0) {
		printk(KERN_ERR "cannot register event-handler function!\n");
		lkst_mod_cleanup();
    return retval;
	}
	evhandler_id = (lkst_evhandler_id) retval;
	
	return 0;
}

static void lkst_mod_cleanup()
{
	/* deregister the event handler. */
	if (evhandler_id != LKST_EVHANDLER_ID_VOID)
		lkst_evhandler_unregister((lkst_evhandler_id)evhandler_id);
	return;
}

/* END */
