/*-*-c++-*-
 * $Id: ctextrange.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CTEXTRANGE_H
#define CTEXTRANGE_H

class CTextRange {
public:
	CTextRange() : x1(0), x2(0), y1(0), y2(0), marked(false) { /* empty */ }
	inline void setMarkStartX(int x) {
		x1 = x;
	}
	inline void setMarkStartY(int y) {
		y1 = y;
	}
	inline void setMarkEndX(int x) {
		x2 = x;
	}
	inline void setMarkEndY(int y) {
		y2 = y;
	}
	inline int markStartX() const {
		return x1;
	}
	inline int markStartY() const {
		return y1;
	}
	inline int markEndX() const {
		return x2;
	}
	inline int markEndY() const {
		return y2;
	}
	inline void setMarked(bool w) {
		marked = w;
	}
	inline bool isMarked() const {
		return marked;
	}
	
private:
	int x1;
	int x2;
	int y1;
	int y2;
	bool marked;	
};

#endif
