/*-*-c++-*-
 * $Id: cchildmanagerbase.h,v 1.2 2002/04/19 15:24:17 felfert Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef _CCHILDMANAGERBASE_H_
#define _CCHILDMANAGERBASE_H_

#include "osdep.h"
#include "cchildimplementation.h"

class QString;
class QStringList;
#include <qlist.h>

class CChildPlugin : public CChildImplementation {
	friend class CChildManagerBase;

public:
	CChildPlugin();
	~CChildPlugin();

	QString Name();
	QString Version();
	QString Description();
	QString Author();
	QString Copyright();
	bool isConfigurable();

	/**
	 * re-implemented from cchildimplementation
	 */
	bool writeStdin(QString);
	bool valid();
	void forkChild();
	bool running();
	void killChild(int);

	int configure(QWidget *);
	cfgMap getConfigValues();
	void setConfigValues(cfgMap);
	bool configured();

private:
	bool Unload();
	bool Load();

	QString name;
	QString version;
	QString description;
	QString author;
	QString copyright;
	QString librarypath;
	bool    loaded;
	bool    configurable;

	CChildImplementation *impl;
#ifdef WIN32
	HINSTANCE libhandle;
#else
	void *libhandle;

	// Disable copy constructor
	CChildPlugin(const CChildPlugin &) : CChildImplementation() {}
#endif
};

typedef QList<CChildPlugin> TPluginList;

/**
 * Base class for platform independant management of a child process.
 *
 * @author Fritz Elfert, based on source from Michael Gesebrecht
 */
class CChildManagerBase {
public:
	CChildManagerBase();
	~CChildManagerBase();

protected:
	/**
	 * Search a directory for shared libraries containing
	 * CChildImplementations.
	 *
	 * @param dirname The directory to search for.
	 *
	 * @returns A list of SChildDescription, describing the
	 *          libraries found. This gan be empty of course.
	 */
	TPluginList *findPlugins(const QString& dirname);
	void refreshPlugins(TPluginList &plist, const QString& dirname);
	QString getPluginLibrary(CChildPlugin *);
};

#endif
/*
 * Local variables:
 * c-basic-offset: 8
 * End:
 */
