/*-*-c++-*-
 * $Id: main.cpp,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>

#include "qlcrash.h"
#include "cmainwin.h"
#include "csplash.h"
#include "cconfigmanager.h"
#include "resourceadapter.h"

int main(int argc, char *argv[])
{
  QApplication a(argc, argv);

  QTranslator tor( 0 );
  tor.load( QString("qlcrash_") + Resource::currentLocale(), Resource::getMessageDir());
  a.installTranslator( &tor );
  CSplash* sp = new CSplash();
#ifndef _DEBUG
  sp->show();
#endif

  CConfigManager* cm = new CConfigManager(&a);
  cm->setFile(QString(DATADIR) + "/qlcrash.conf");
  cm->setFile(cm->homeDir() + "/.qlcrash");
  QString font = cm->item(CFG_GRP_APP, CFG_ATT_APP_FONTFAMILY, a.font().family());
  int size = cm->item(CFG_GRP_APP, CFG_ATT_APP_FONTSIZE, a.font().pointSize());
  a.setFont(QFont(font, size));

  QLcrashApp *qlcrash = new QLcrashApp(cm);
  a.setMainWidget(qlcrash);

  int ret = a.exec();
  delete qlcrash;

  return ret;

 /*
 CNConsole* con = new CNConsole(0);
 a.setMainWidget(con);
 con->show();
 con->append("Hallo\nWelt.");
 con->update();
*/

/*
	CConsole* con = new CConsole(0);
	con->resize(320, 200);
	a.setMainWidget(con);
	con->show();
	
	CChildManager* cm = new CChildManager(con);
	cm->setChildPath("/home/let/Gcc/lkcdutils/lcrash/lcrash");
	QObject::connect(con, SIGNAL(sigLine(QString)), cm, SLOT(slotLine(QString)));
	QObject::connect(cm, SIGNAL(sigLineStdOut(QString)), con, SLOT(slotLine(QString)));
	QObject::connect(cm, SIGNAL(sigLineStdErr(QString)), con, SLOT(slotLine(QString)));
	QObject::connect(cm, SIGNAL(sigChildDied()), &a, SLOT(quit()));
	cm->forkChild();
*/
/*	CGraphManager* gm = new CGraphManager(0);
	a.setMainWidget(gm);
	gm->resize(640, 480);
	gm->show();
*/
/*
	CMainWin* mw = new CMainWin(0);
	a.setMainWidget(mw);
	mw->resize(320, 400);
	mw->show();	
*/

	return a.exec();
}
