/*-*-c++-*-
 * $Id: ctaskitem.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CTASKITEM_H
#define CTASKITEM_H


/**Store a task name and its address
  *@author Michael Geselbracht
  */

class CTaskItem {
public: 
	CTaskItem() { }
	~CTaskItem() { }
	
	inline const QString& name() const {
		return oName;
	}
	inline void setName(const QString& name) {
		oName = name;
	}
	inline const QString& address() const {
		return oAddress;
	}
	inline void setAddress(const QString& addr) {
		oAddress = addr;
	}
	inline const QString& pid() const {
		return oPid;
	}
	inline void setPid(const QString& p) {
		oPid = p;
	}
	inline const QString& status() const {
		return oStatus;
	}
	inline void setStatus(const QString& s) {
		oStatus = s;
	}
	inline const QString& cpu() const {
		return oCpu;
	}
	inline void setCpu(const QString& cpu) {
		oCpu = cpu;
	}
	
private:
	QString oName;
	QString oAddress;
	QString oPid;
	QString oStatus;
	QString oCpu;
};

#endif
