/*-*-c++-*-
 * $Id: ctaskbutton.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CTASKBUTTON_H
#define CTASKBUTTON_H

#include <qpushbutton.h>

class CTaskBar;

/**A QPushButton child for use in CTaskBar.
  *@author Michael Geselbracht
  */

class CTaskButton : public QPushButton {
	Q_OBJECT
	
public:
	CTaskButton(QWidget* win, CTaskBar* parent, const char* name=0);
	~CTaskButton();
	
	inline QWidget* widget() {
		return oWidget;
	}
	
	virtual QSize sizeHint() const;
	virtual bool eventFilter(QObject* sender, QEvent* e);
	virtual void setText(const QString& text);
	
	// get original widget caption
	QString text() const;
	
	// set counter for duplicate captions
	void setNumber(int nr);
	
	inline int number() const {
		return oCounter;
	}
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	virtual void mousePressEvent(QMouseEvent*);
	void updateLabel();
	
protected slots:
	void slotClicked();
	
private:
	QWidget* oWidget;
	QSize oSizeHint;
	QString oText;
	int oCounter;
};

#endif
