/*-*-c++-*-
 * $Id: csearchlistdialog.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CSEARCHLISTDIALOG_H
#define CSEARCHLISTDIALOG_H

#include <qdialog.h>
#include <qlist.h>

class CListView;

class QLabel;
class QComboBox;
class QListViewItem;
class QLineEdit;

/**Search an item in given list view
  *@author Michael Geselbracht
  */

class CSearchListDialog : public QDialog  {
	Q_OBJECT
	
	friend class CListView;
	
public:
	CSearchListDialog(CListView* parent, int findCol=-1, const char* name=0);
	~CSearchListDialog();
	
	virtual bool eventFilter(QObject*, QEvent*);
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	virtual bool event(QEvent*);
	
	// Specify the column which contains the desired entries. Defaults to 0.
	inline void setFindColumn(int col) {
		oFindCol = col;
	}
	
private slots:	
	void slotTextChanged(const QString&);
	void slotSelectionChanged();
	void slotHighlighted(int);
	void slotFilterChanged();

private:
	void initComboBox();
	void updateList();
	
private:
	QLabel* oLabel;
	QComboBox* oEdit;
	QLabel* oFilterLabel;
	QLineEdit* oFilter;
	CListView* oParent;
	QString oLastStr;
	QString oLastFilter;
	int oFindCol;
};

#endif
