/*-*-c++-*-
 * $Id: cpaintarea.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CPAINTAREA_H
#define CPAINTAREA_H

#include <qframe.h>

/**
  *@author Michael Geselbracht
  */

class CPaintArea : public QFrame {
   Q_OBJECT

public: 
	CPaintArea(QWidget *parent, const char *name=0);
	~CPaintArea();
	
protected:
	virtual void paintEvent(QPaintEvent*);
	virtual void mouseMoveEvent(QMouseEvent*);
	virtual void mousePressEvent(QMouseEvent*);
	virtual void mouseDoubleClickEvent(QMouseEvent*);
	
signals:
	void sigPaintEvent();
	
	/*  Emit signals in mouse events instead of installing
		an event filter for this class. This may change some day.
	*/
	void sigMouseMoved(QMouseEvent*);
	void sigMousePressed(QMouseEvent*);
	void sigMouseDoubleClicked(QMouseEvent*);
};

#endif
