/*-*-c++-*-
 * $Id: cgraphlabel.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CGRAPHLABEL_H
#define CGRAPHLABEL_H

#include <qwidget.h>
#include <qlabel.h>

/**A QLabel class which signals its move events.
  *@author Michael Geselbracht
  */

class CGraphLabel : public QLabel  {
   Q_OBJECT

public: 
	CGraphLabel(QWidget *parent, const char *name=0);
	~CGraphLabel();
	
signals:
	void sigMoveEvent(QMouseEvent*);
	void sigPressEvent(QMouseEvent*);
	void sigReleaseEvent(QMouseEvent*);
	
protected:
	virtual void mouseMoveEvent(QMouseEvent*);
	virtual void mousePressEvent(QMouseEvent*);
	virtual void mouseReleaseEvent(QMouseEvent*);
};

#endif
