/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */

/** 
 ** Block Memory Allocator 
 **/

extern int alloc_debug;

/* Flags that determine if a block is temp or perm. Note that these values
 * are the same as the KLIB flags K_TEMP and K_PERM. These defines are 
 * here so that applicatons using only the liballoc library need not 
 * include klib.h.
 */
#define B_FREE 0
#define B_TEMP 1
#define B_PERM 2

#define ALLOCFLG(flags) ((flags & B_PERM) ? B_PERM : B_TEMP)

/**
 ** block allocation operation function prototypes
 **/
int init_mempool(int, int, int);

void free_mempool(void);

void * alloc_block(	
	int		/* size of block to allocate */, 
	int		/* flag (K_TEMP/K_PERM) */, 
	void * 	    	/* return address */);

void * realloc_block(
	void *	    	/* pointer to block to reallocate */,
	int 		/* size of new block */,
	int         	/* flag (K_TEMP/K_PERM) */,
	void * 	    	/* return address */);

void * dup_block(
	void *	    	/* pointer to block to dup */, 
	int	    	/* flag (B_TEMP/B_PERM) */,
	void * 	    	/* return address */);

void * str_to_block(
	char *		/* pointer to string to copy */,
	int         	/* flag (B_TEMP/B_PERM) */,
	void * 	    	/* return address */);

void free_block(
	void *	    	/* address of block to free */);

void free_temp_blocks(void);

int is_temp_block(
	void *		/* address of block to check */);
