%define name lkstutils
%define version 1.4
%define release 1

%define prefix /usr

Name: %{name}
Summary: Linux Kernel State Tracer (LKST) Utilities
Version: %{version}
Release: %{release}
Packager: HITACHI,LTD. FUJITSU,LTD.
Group: Applications/System
Source: %{name}-%{version}.tar.gz
Copyright: GPL
Vendor: HITACHI,LTD. FUJITSU,LTD.
URL: http://sourceforge.net/projects/lkst/
BuildRoot: %{_tmppath}/%{name}-root/
BuildPreReq: autoconf

%description
The lkstutils package contains user tools for
Linux Kernel State Tracer (LKST). It includes
the following tools.

- lkstbuf         Control kernel event buffer in LKST.
- lksteh          Control event-handler in LKST. 
- lkst            Control status of LKST.
- logformat.pl    display LKST trace data
- lkstm           Control maskset in LKST.
- lkstlogd        LKST logging utility.
- lkstlogger      Tells LKST that a specified event has occurred.
- lkstdump        Extract LKST trace data from LKCD dump file. 

Authors:
--------
   K.SERIZAWA <serizawa@sdl.hitachi.co.jp>
   T.NAKAMURA <tetsu@crl.hitachi.co.jp>
   K.HATASAKI <keisukeh@crl.hitachi.co.jp>
   Y.GOTO <y-goto@jp.fujitsu.com> 
   T.INDOH <indou.takao@jp.fujitsu.com>
   M.HIRAMATSU <hiramatu@sdl.hitachi.co.jp>

%prep
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT
%setup
%build
autoconf
./configure --prefix=%{prefix} \
	    --with-ksrc=/usr/src/linux \
	    --mandir=%{_mandir}
make

%install
mkdir -p $RPM_BUILD_ROOT%{prefix}/sbin
mkdir -p $RPM_BUILD_ROOT%{prefix}/share/sial/lcrash
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
make LKSTLOGD_LOGDIR=$RPM_BUILD_ROOT/var/log/lkst \
     prefix=$RPM_BUILD_ROOT%{prefix} \
     mandir=$RPM_BUILD_ROOT%{_mandir} \
     install
#mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}
#install -m 644 redhat/lkstlogd $RPM_BUILD_ROOT%{_sysconfdir}
mkdir -p $RPM_BUILD_ROOT%{_initrddir}
install -m 755 redhat/lkst.init $RPM_BUILD_ROOT%{_initrddir}/lkst
install -m 755 redhat/lkstlogd.init $RPM_BUILD_ROOT%{_initrddir}/lkstlogd


%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
[ -c /dev/lkst ] || mknod --mode=600 /dev/lkst c 231 0
chkconfig --add lkst
chkconfig --add lkstlogd

%preun
chkconfig --del lkst
chkconfig --del lkstlogd

%files
%defattr(-, root, root)
%doc redhat/*
#%config(missingok) %{_sysconfdir}/lkstlogd
%{_initrddir}/lkst
%{_initrddir}/lkstlogd
%{prefix}/sbin/lkstbuf
%{prefix}/sbin/lksteh
%{prefix}/sbin/lkst
%{prefix}/sbin/lkstm
%{prefix}/sbin/logformat.pl
%{prefix}/sbin/lkstlogd
%{prefix}/sbin/lkstlogger
%{_mandir}/man8/*
%{_mandir}/man1/*
%dir /var/log/lkst
%{prefix}/share/sial/lcrash/lkstdump.sial
%{prefix}/share/sial/lcrash/lkstdumplib.so

%changelog
* Mon Feb 17 2003 HITACHI,LTD., FUJITSU,LTD.
- Upgrade against for v1.4

* Mon Nov 25 2002 HITACHI,LTD., FUJITSU,LTD.
- Fixed some bugs.

* Fri Aug 30 2002 HITACHI,LTD., FUJITSU,LTD.
- Release v1.3
  Performance improvement of Kernel Hooks.
  Modify default maskset.
  Support CSV format by lkstbuf command.
  Add and modify APIs for event-handler.
  Add config to delete hooks on inline func.
  Add script to make /dev/lkst.
  Fix some bugs.

* Mon May 13 2002 Masami HIRAMATSU <hiramatu@sdl.hitachi.co.jp>
- customize from original.(rel 2)
