/*-*-c++-*-
 * $Id: tcpplugin.h,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (Michael.Geselbracht@de.ibm.com)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef _TCPPLUGIN_H_
#define _TCPPLUGIN_H_

#include "generic_h.h"
#include <qcstring.h>

class DLLEXPORT QString;
class QSocket;
class QTimer;

#ifdef WIN32
#pragma pack(push)
#pragma pack(1)
typedef struct {
	char c;
	unsigned short l;
} msgHead;
#pragma pack(pop)
#else
typedef struct {
	char c;
	unsigned short l __attribute__((packed));
} msgHead __attribute__((packed));
#endif

class DLLEXPORT RXbuffer {
 public:
	RXbuffer();
	~RXbuffer();

	void append(const char *, int);
	void remove(unsigned int);
	int length() { return _len; }
	bool isEmpty() { return (_len == 0); }
	QString left(unsigned int len=0xffffffff);

	operator const char *() { return _buf; }
 private:
	char *_buf;
	char *_tmp;
	unsigned long _len;
	unsigned long _size;
};

class DLLEXPORT CTcpChild : public CChildImplementation {
    Q_OBJECT

public:
    CTcpChild();
    ~CTcpChild();

    bool writeStdin(QString);

    /**
     * Check if program exists and is a
     * valid executable.
     */
    bool valid();

    /** Create a child process.
     *
     */
    void forkChild();

    /** Check if child is running.
    *
    */
    bool running();

    /** Send a signal to the child
    */
    void killChild(int);

    int configure(QWidget *parent);

    cfgMap getConfigValues();

    void setConfigValues(cfgMap);

    bool configured();

private slots:
    void slotTimeout();
    void slotConnected();
    void slotReadData();
    void slotError(int);
    void slotConnectionClosed();

private:
	enum {
		DEMUX_NONE,
		DEMUX_CTRL,
		DEMUX_STDOUT,
		DEMUX_STDERR,
	};

	bool tryConnect();
	void sendHeader();
	void writeMsg(QString cmd, char dst='C');

	RXbuffer rawBuffer;
	QString  CtrlBuffer;

	QString host;
	int     port;

	QString path;
	QString argv;

	QSocket *socket;
	QTimer *timer;

	int validAnswer;
	int startAnswer;
	int runningAnswer;
	int killAnswer;
	int timeout;

	bool established;
	bool timedout;
	bool failed;
	bool justStarted;

	int  dest;

	msgHead mh;
};


#endif
