/*-*-c++-*-
 * $Id: ctoolbutton.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "ctoolbutton.h"

#include <qpopupmenu.h>
#include <qtimer.h>

CToolButton::CToolButton(const QPixmap& pm, const QString& textLabel, const QString& groupText, QObject* receiver, const char* slot, QToolBar* parent, const char* name)
	: QToolButton(pm, textLabel, groupText, receiver, slot, parent, name)
	, oTimer(0)
	, oPopup(0)
{
	connect(this, SIGNAL(pressed()), SLOT(slotPressed()));
	connect(this, SIGNAL(released()), SLOT(slotReleased()));
}

CToolButton::~CToolButton()
{
}

void
CToolButton::setPopup(QPopupMenu* pop)
{
	if (oTimer == 0) {
		oTimer = new QTimer(this);
		
		connect(oTimer, SIGNAL(timeout()), SLOT(slotTimeout()));
	}
	
	oPopup = pop;
}

void
CToolButton::slotTimeout()
{
	int ret = oPopup->exec(mapToGlobal(rect().bottomLeft()));
	if (ret != -1) {
		emit sigActivated(ret);
	}
	
	setDown(false);
}

void
CToolButton::slotPressed()
{
	oTimer->start(popupDelay(), true);
}

void
CToolButton::slotReleased()
{
	oTimer->stop();
}
