/*-*-c++-*-
 * $Id: cwalkexpressiondialog.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "cwalkexpressiondialog.h"
#include "crashtypes.h"

#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qframe.h>
#include <qapplication.h>
#include <qlineedit.h>

#include "resourceadapter.h"

CWalkExpressionDialog::CWalkExpressionDialog(QWidget *parent, const char *name )
	: QDialog(parent,name, true)
{
	oTopFrame = new QFrame(this);
	oTopFrame->setFrameStyle(QFrame::Raised | QFrame::Panel);
	oBotFrame = new QFrame(this);
	oBotFrame->setFrameStyle(QFrame::Raised | QFrame::Panel);
	
	// label
	oTypeL = new QLabel(tr("Type") + ":", oTopFrame);
	oTypeL->setAutoResize(true);
	oTypeL->update();
	oMemberL = new QLabel(tr("Member") + ":", oTopFrame);
	oMemberL->setAutoResize(true);
	oMemberL->update();
	oAddressL = new QLabel(tr("Address") + ":", oTopFrame);
	oAddressL->setAutoResize(true);
	oAddressL->update();
	
	// combobox
	oTypeC = new QComboBox(oTopFrame);
	oTypeC->setAutoCompletion(true);
	oTypeC->setEditable(true);
	oTypeC->lineEdit()->installEventFilter(this);
	oTypeC->setDuplicatesEnabled(false);
	oMemberC = new QComboBox(oTopFrame);
	oMemberC->setAutoCompletion(true);
	oMemberC->setEditable(true);
	oMemberC->lineEdit()->installEventFilter(this);
	oMemberC->setDuplicatesEnabled(false);
	oAddressC = new QComboBox(oTopFrame);
	oAddressC->setAutoCompletion(true);
	oAddressC->setEditable(true);
	oAddressC->lineEdit()->installEventFilter(this);
	oAddressC->setDuplicatesEnabled(false);
	
	// button
	oOk = new QPushButton(tr("Ok"), oBotFrame);
	oOk->setAutoDefault(false);
	oCancel = new QPushButton(tr("Cancel"), oBotFrame);
	oCancel->setAutoDefault(false);
	connect(oOk, SIGNAL(clicked()), SLOT(slotOk()));
	connect(oCancel, SIGNAL(clicked()), SLOT(slotCancel()));
	
	// set height for widgets
	const int h = 8 + QApplication::fontMetrics().height();
	oTypeL->setFixedHeight(h);
	oMemberL->setFixedHeight(h);
	oAddressL->setFixedHeight(h);
	oTypeC->setFixedHeight(h);
	oMemberC->setFixedHeight(h);
	oAddressC->setFixedHeight(h);
	oOk->setFixedHeight(h);
	oCancel->setFixedHeight(h);
	
	oTopFrame->setFixedHeight(5 + h + 5);
	oBotFrame->setFixedHeight(5 + h + 5);
	
	setFixedHeight(oTopFrame->height() + oBotFrame->height());
	
	// frame positions are fixed
	oTopFrame->move(0, 0);
	oBotFrame->move(0, oTopFrame->height());
	
	setCaption(stdCaption(tr("Walk") + "..."));
	setIcon(Resource::getBitmap(IDR_PNG7));
}

CWalkExpressionDialog::~CWalkExpressionDialog()
{
}

void
CWalkExpressionDialog::resizeEvent(QResizeEvent*)
{
	const int cWidth = (width() - oTypeL->width() - oMemberL->width() - oAddressL->width() - 7*5) / 3;
	const int w = 5;
	
	oTopFrame->resize(width(), 1);
	oBotFrame->resize(width(), 1);
	
	oTypeL->move(w, w);
	oTypeC->setGeometry(oTypeL->x() + oTypeL->width() + w, w, cWidth, 1);
	oMemberL->move(oTypeC->x() + oTypeC->width() + w, w);
	oMemberC->setGeometry(oMemberL->x() + oMemberL->width() + w, w, cWidth, 1);
	oAddressL->move(oMemberC->x() + oMemberC->width() + w, w);
	oAddressC->setGeometry(oAddressL->x() + oAddressL->width() + w, w, cWidth, 1);
	
	oCancel->move(width() - w - oCancel->width(), w);
	oOk->move(oCancel->x() - w - oOk->width(), w);
}

bool
CWalkExpressionDialog::eventFilter(QObject* obj, QEvent* e)
{
	if (e->type() == QEvent::KeyPress &&
			(
				((QKeyEvent*)e)->key() == Key_Return ||
				((QKeyEvent*)e)->key() == Key_Enter ||
				((QKeyEvent*)e)->key() == Key_Tab
			)
		)
			
	{
		if (((QKeyEvent*)e)->key() == Key_Tab) {
			QKeyEvent ne(QEvent::KeyPress, Key_Return, '\r', 0);
			obj->event(&ne);
			
			return true;
		}
		
		if (obj == oTypeC->lineEdit()) {
			oMemberC->setFocus();
		}
		else if (obj == oMemberC->lineEdit()) {
			oAddressC->setFocus();
		}
		else if (obj == oAddressC->lineEdit()) {
			oOk->setFocus();
		}
	}
	
	return false;
}

void
CWalkExpressionDialog::slotOk()
{
	accept();
}

void
CWalkExpressionDialog::slotCancel()
{
	reject();
}

QString
CWalkExpressionDialog::type() const
{
	return oTypeC->currentText();
}

QString
CWalkExpressionDialog::member() const
{
	return oMemberC->currentText();
}

QString
CWalkExpressionDialog::address() const
{
	return oAddressC->currentText();
}

int
CWalkExpressionDialog::fExec()
{	
	oTypeC->lineEdit()->setFocus();
	int ret = exec();
		
	return ret;
}

void
CWalkExpressionDialog::clear()
{
	// clear all boxes
	oTypeC->clearEdit();
	oMemberC->clearEdit();
	oAddressC->clearEdit();
}

void
CWalkExpressionDialog::setDefault(const QString& type, const QString& member, const QString& addr)
{
	oTypeC->setEditText(type);
	oTypeC->lineEdit()->selectAll();
	oMemberC->setEditText(member);
	oMemberC->lineEdit()->selectAll();
	oAddressC->setEditText(addr);
	oAddressC->lineEdit()->selectAll();
}
