/*-*-c++-*-
 * $Id: ctaskbutton.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <qpopupmenu.h>
#include <qfont.h>

#include "ctaskbutton.h"
#include "ctaskbar.h"

CTaskButton::CTaskButton(QWidget* win, CTaskBar* parent, const char* name)
	: QPushButton(parent, name)
	, oWidget(win)
	, oCounter(1)
{
	setToggleButton(true);
	setMaximumWidth(300);
	setText(win->caption());
	
	win->installEventFilter(this);
	
	QFontMetrics fm(font());
	int w = fm.width(text());
	oSizeHint.setWidth(((w < maximumWidth()) ? w : maximumWidth()));
	
	adjustSize();
	
	connect(this, SIGNAL(clicked()), SLOT(slotClicked()));
}

CTaskButton::~CTaskButton()
{
}

void
CTaskButton::resizeEvent(QResizeEvent* e)
{
	updateLabel();
	QPushButton::resizeEvent(e);
}

void
CTaskButton::updateLabel()
{
	QString label = (oCounter > 1) ? QString(" <") + QString::number(oCounter) + ">" : QString("");
	if (!oWidget->isVisible()) {
		label = QString("(") + oText + label + QString(")");
	}
	else {
		label = oText + label;
	}
	
	oWidget->setCaption(label);
	
	QFontMetrics fm(font());
	int w = fm.width(label);
	
	while (w > 5 && w > width() - 6) {
		label.truncate(label.length() - 1);
		w = fm.width(label);
	}
	
	QPushButton::setText(label);
}

void
CTaskButton::mousePressEvent(QMouseEvent* e)
{
	if (e->button() == RightButton) { // show context menu
		QPopupMenu pm(0);
		pm.insertItem(tr("Restore"), 1);
		pm.insertItem(tr("Minimize"), 2);
		pm.insertItem(tr("Maximize"), 3);
		pm.insertSeparator();
		pm.insertItem(tr("Close"), 4);
		pm.adjustSize();
		
		if (!oWidget->isVisible()) {
			pm.setItemEnabled(2, false);
		}
		else if (oWidget->size() == oWidget->parentWidget()->parentWidget()->size()) {
			pm.setItemEnabled(3, false);
		}
		else {
			pm.setItemEnabled(1, false);
		}
		
		int ret = pm.exec(mapToGlobal(QPoint(0, 0)));
		switch (ret) {
			case 1:
				oWidget->showNormal();
				oWidget->setFocus();
				break;
			case 2:
				oWidget->showMinimized();
				break;
			case 3:
				oWidget->showMaximized();
				oWidget->setFocus();
				break;
			case 4:
				oWidget->close();
				break;
		}
	}
	else if (e->button() == LeftButton) {
		if (!isOn()) {
			QPushButton::mousePressEvent(e);
		}
	}
}

QSize
CTaskButton::sizeHint() const
{	
	return oSizeHint;
}

void
CTaskButton::slotClicked()
{
	if (!widget()->isVisible()) {
		widget()->show();
	}
	widget()->setFocus();
}

bool
CTaskButton::eventFilter(QObject*, QEvent* e)
{
	CTaskBar* p = dynamic_cast<CTaskBar*>(parentWidget());
	
	int type = e->type();
	switch (type) {
		case QEvent::Close:
			p->removeWidget(widget());
			break;
		case QEvent::Hide:
			updateLabel();
			break;
		case QEvent::Show:
			updateLabel();
			break;
		case QEvent::FocusIn:
			p->cbActivated(widget());
			break;
			
		default:
			break;
	}
	
	return false;
}

QString
CTaskButton::text() const
{
	return oText;
}

void
CTaskButton::setText(const QString& text)
{
	oText = text;
	oWidget->setCaption(text);
	updateLabel();
}

void
CTaskButton::setNumber(int nr)
{
	oCounter = nr;
}
