/*
 * include/asm-s390/kl_types.h
 *
 * S390 version
 *   Copyright (C) 2001 IBM Deutschland Entwicklung GmbH,
 *                      IBM Corporation
 *
 * Derived from include/asm-i386/kl_types.h
 *   Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */

/* The following typedef should be used for variables or return values
 * that contain kernel virtual or physical addresses. It will be sized 
 * depending on which architecture KLIB is being built for. If the address
 * exceeds 32-bit addressable space, then a 64-bit value will be used.
 */
typedef uint32_t	kaddr_t;

/* The following typedef should be used for variables referring to the 
 * physical addresses. (It is same as kaddr_t for archs where number
 * of virtual and physical address lines are equal)
 */
typedef kaddr_t		paddr_t;

/* The following typedef should be used when converting a pointer value
 * (either kernel or application) to an unsigned value for pointer
 * calculations.
 */
typedef uint32_t        uaddr_t;

/* KLIB error type
 */
typedef uint64_t 	k_error_t;

/* Typedef that allows a single fprintf() call to work for both
 * 32-bit and 64-bit pointer values (architecture specific).
 */
#define UADDR(X) ((uaddr_t)X)
#define UADDR64(X) ((uint64_t)((uaddr_t)X))
#define FMTPTR  ""
#define FMT64  "ll"
