/*-*-c++-*-
 * $Id: resourceadapter.h,v 1.1 2002/01/28 15:38:33 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef _RESOURCEADAPTER_H_
#define _RESOURCEADAPTER_H_

#include "osdep.h"

class QPixmap;
class QString;

#ifndef WIN32
#include "crashtypes.h"

// Keep these in sync with win32/qlcrash.rc

#define IDR_PNG1 (DATADIR "/logo.png")
#define IDR_PNG2 (DATADIR "/logo-small.png")
#define IDR_PNG3 (DATADIR "/plugin_activated.png")
#define IDR_PNG4 (DATADIR "/plugin_configured.png")
#define IDR_PNG5 (DATADIR "/plugin_unconfigured.png")
#define IDR_PNG6 (DATADIR "/lo16-app-qlcrash.png")
#define IDR_PNG7 (DATADIR "/lo32-app-qlcrash.png")
#else
#include "resource.h"
#endif

class Resource {

public:
#ifdef WIN32
	// retrieves a bitmap from compiled-in resources
	static QPixmap &getBitmap(int);
#else
	static QPixmap &getBitmap(const char *);
#endif
	static QString getPluginDir();
	static QString getMessageDir();
	static QString currentLocale();
};

#endif
