/*-*-c++-*-
 * $Id: cprintexprdialog.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "cprintexprdialog.h"
#include "crashtypes.h"

#include <qcombobox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qframe.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qapplication.h>

#include "resourceadapter.h"

CPrintExprDialog::CPrintExprDialog(const QString& label, QWidget *parent, const char *name)
	: QDialog(parent, name, true)
{
	setCaption(stdCaption(tr("Print...")));
	setIcon(Resource::getBitmap(IDR_PNG7));
	oTopFrame = new QFrame(this);
	oBotFrame = new QFrame(this);
	oTopFrame->setFrameStyle(QFrame::Panel | QFrame::Raised);
	oBotFrame->setFrameStyle(QFrame::Panel | QFrame::Raised);
	
	oLabel = new QLabel(label + ":", oTopFrame);
	oLabel->setAutoResize(true);
	oLabel->update();
		
	oBox = new QComboBox(true, oTopFrame);
	oBox->setAutoCompletion(true);
	oBox->setDuplicatesEnabled(false);
	oBox->setEditable(true);
	oBox->lineEdit()->installEventFilter(this);
		
	oCountLabel = new QLabel(tr("Count") + ":", oTopFrame);
	oCountLabel->setAutoResize(true);
	oCountLabel->update();
		
	oCount = new QLineEdit(oTopFrame);
	oCount->setValidator(new QIntValidator(1, 500, this));
	oCount->setText("1");
	oCount->installEventFilter(this);
	
	oOk = new QPushButton(tr("Ok"), oBotFrame);
	oOk->setAutoDefault(false);
	oCancel = new QPushButton(tr("Cancel"), oBotFrame);
	oCancel->setAutoDefault(false);
	
	connect(oOk, SIGNAL(clicked()), SLOT(slotOk()));
	connect(oCancel, SIGNAL(clicked()), SLOT(slotCancel()));
	
	const int h = 8 + QApplication::fontMetrics().height();
	oLabel->setFixedHeight(h);
	oBox->setFixedHeight(h);
	oCountLabel->setFixedHeight(h);
	oCount->setFixedHeight(h);
	oOk->setFixedHeight(h);
	oCancel->setFixedHeight(h);
	
	oTopFrame->setFixedHeight(5 + h + 5);
	oBotFrame->setFixedHeight(5 + h + 5);
	
	setFixedHeight(oTopFrame->height() + oBotFrame->height());
	setMinimumSize(200, oTopFrame->height() + oBotFrame->height());
	
	oTopFrame->move(0, 0);
	oBotFrame->move(0, oTopFrame->height());
	
	oBox->setFocus();
}

CPrintExprDialog::~CPrintExprDialog()
{
}

void
CPrintExprDialog::resizeEvent(QResizeEvent*)
{
	const int w = 5;
	oTopFrame->resize(width(), 1);
	oBotFrame->resize(width(), 1);
	oCount->resize(30, 1);

	oLabel->move(w, w);
	oBox->setGeometry(
		oLabel->x() + oLabel->width() + w,
		w,
		width() - w - oLabel->width() - w - oCountLabel->width() - w - oCount->width() - 2*w,
		1
	);

	oCountLabel->move(oBox->x() + oBox->width() + w, w);
	oCount->move(oCountLabel->x() + oCountLabel->width() + w, w);

	oCancel->move(width() - w - oCancel->width(), w);
	oOk->move(oCancel->x() - w - oOk->width(), w);
}

bool
CPrintExprDialog::eventFilter(QObject* obj, QEvent* e)
{
	if (e->type() == QEvent::KeyPress &&
			(
				((QKeyEvent*)e)->key() == Key_Enter ||
				((QKeyEvent*)e)->key() == Key_Return ||
				((QKeyEvent*)e)->key() == Key_Tab
			)
		)
	{
		if (((QKeyEvent*)e)->key() == Key_Tab) {
			QKeyEvent ne(QEvent::KeyPress, Key_Return, '\r', 0);
			obj->event(&ne);
			
			return true;
		}
		
		if (obj == oBox->lineEdit()) {
			oCount->setFocus();
			oCount->selectAll();
		}
		else if (obj == oCount) {
			oOk->setFocus();
		}
	}
	
	return false;
}

void
CPrintExprDialog::slotOk()
{
	accept();
}

void
CPrintExprDialog::slotCancel()
{
	reject();
}

void
CPrintExprDialog::removeLastInput()
{
	oBox->clearEdit();
}

QString
CPrintExprDialog::text() const
{
	return oBox->currentText();
}

void
CPrintExprDialog::setText(const QString& str, bool rewindCursor)
{
	oBox->setEditText(str);
	oCount->setText("1");

	if (rewindCursor) { // set cursor to leftmost position
		oBox->lineEdit()->setCursorPosition(0);
	}

	oBox->setFocus();
}

int
CPrintExprDialog::count() const
{
	return oCount->text().toInt();
}
