/*-*-c++-*-
 * $Id: cnumberofelementsdialog.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CNUMBEROFELEMENTSDIALOG_H
#define CNUMBEROFELEMENTSDIALOG_H

#include <qdialog.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>

/**
  *@author Michael Geselbracht
  */

class CNumberOfElementsDialog : public QDialog {
	Q_OBJECT
	
public: 
	CNumberOfElementsDialog(QWidget* parent, const char* name=0);
	~CNumberOfElementsDialog();
	
	int value() const;

protected:
	virtual void resizeEvent(QResizeEvent*);

private slots:
	void slotOk();
	void slotCancel();
	void slotReturnPressed();
	
private:
	QLabel* oLabel;
	QLineEdit* oEdit;
	QPushButton* oOk;
	QPushButton* oCancel;
};

#endif
