/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2002 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by K.Hatasaki <keisukeh@crl.hitachi.co.jp>
 *
 ************************************************************/

#include <stdlib.h>
#include "command.h"

#define NAME	"lksteh"
#define VERSION "1.3"

#define NR_CMD_MAX	128

void usage(void);

void call_usage(int* , char**);
void call_version(int*, char**);
void call_list(int*, char**);
void call_ctrl(int*, char**);
void call_getid(int*, char**);

int main(int argc, char **argv)
{
	int i;

	struct command cmd[NR_CMD_MAX] = 
	{
		[0] = {"help", &call_usage},
		[1] = {"ver", &call_version},
		[2] = {"version", &call_version},
		[3] = {"list", &call_list},
		[4] = {"ls", &call_list},
		[5] = {"control", &call_ctrl},
		[6] = {"ctrl", &call_ctrl},
		[7] = {"c", &call_ctrl},
		[8] = {"find", &call_getid},
		[9] = {"", NULL},
	};

	if (argc == 1) { /* no command */
		usage();
	} else {
		for (i = 0; i < NR_CMD_MAX; i++) {
			if (!cmd[i].func)
				break;
			if (!strcmp(cmd[i].name, argv[1])) {
				cmd[i].func(&argc, argv);
				break;
			}
		}
		if (!cmd[i].func)
			badcommand(argv[1]);
	}

	exit(0);
}

void usage(void)
{
	printf("Invoke an event-handler-control-function.\n");
	printf("Usage:\n\t%s command [option(s)]\n\n", NAME);
	printf("<COMMAND>\n");
	printf("control/ctrl/c\tInvoke an event-handler-control-function.\n");
	printf("\t\t<OPTION>\n");
	printf("\t\t-e event_handler_id [-f file_name]\n");
	printf("\t\t-n event_handler_name [-f file_name]\n");
	printf("find\t\tFind an id from name of the event-handler.\n");
	printf("\t\t<OPTION>\n");
	printf("\t\t-n event_handler_name\n");
	printf("list/ls\t\tOutput a list of all event-handlers.\n");
	printf("version/ver\tPrint version of this command.\n");
	printf("help\t\tPrint this message.\n");
	exit(0);
}

void call_usage(int *argc, char **argv)
{
	usage();
}

void call_version(int *argc, char **argv)
{
	version(NAME, VERSION);
}


void call_list(int *argc, char **argv)
{
	evhandler_list();
}

char name[LKST_EVHANDLER_NAME_LEN] = {0};

void call_ctrl(int *argc, char **argv)
{
	int c;
	lkst_evhandler_id id=LKST_EVHANDLER_ID_VOID;
	char file_name[255]={0};

	while((c = getopt(*argc, argv, "e:f:")) != EOF) {
		switch(c) {
		case 'n' :
			strncpy(name, optarg, LKST_EVHANDLER_NAME_LEN-1);
			break;
		case 'e' :
			id = strtol(optarg,NULL,0);
			break;
		case 'f' :
			strncpy(file_name, optarg, 255);
			break;
		default :
			usage();
			break;
		}
	}

	if ((id==LKST_EVHANDLER_ID_VOID && name[0]==0) ||
	    (id!=LKST_EVHANDLER_ID_VOID && name[0]!=0))
		needopt();

	evhandler_ctrl(id, name, file_name);
}

void call_getid(int *argc, char **argv)
{
	int c;

	c = getopt(*argc, argv, "n:");

	switch(c) {
	case 'n' :
		strncpy(name, optarg, LKST_EVHANDLER_NAME_LEN-1);
		break;
	case -1:
		needopt();
		break;
	default :
		usage();
		break;
	}

	if(name[0]=='\0')
		needopt();
	
	evhandler_getid(name);
}
