/************************************************************
 *
 * COPYRIGHT (C) FUJITSU,LTD. 2001 ALL RIGHTS RESERVED. 
 *
 ************************************************************/

#ifndef _LINUX_BUFFER_H
#define _LINUX_BUFFER_H

#include <time.h>		/* for struct timeval */
#include "command.h"

#define __KERNEL__
#include <linux/wait.h>
#undef __KERNEL__
#define CMD_LKSTDUMP
#include <linux/lkst_private.h>


/* event data index */
#define LKST_EDATA_NAME   0
#define LKST_EDATA_FILTER 1
#define LKST_EDATA_ARG1   2
#define LKST_EDATA_ARG2   3
#define LKST_EDATA_ARG3   4
#define LKST_EDATA_ARG4   5
#define LKST_EDATA_ID_MIN 0x01
#define LKST_EDATA_ID_MAX 0x0ffe

#define LKST_STRUCT_MAX 0x0ffe + 0xffe

/* Prototype declaration */
signed long cfnc_ascending(const void *pointer1, const void *pointer2);
signed long cfnc_descending(const void *pointer1, const void *pointer2);
void help_viewer(char*);
void clock_viewer(unsigned long, unsigned long,int);

/* argument to function"command_analyze" */
struct lkst_arg_command_analyze {
	char* program_name;                     /* name of Execution file             */
	int   arg_filter_flag;                  /* 1=(-e option published) or 0=(not) */
	char  event_work[255];                  /* work array                         */
};

/* argument to function"buffer_save" */
struct lkst_arg_buffer_save {
	lkst_buffer_id		id;
	int			cpu;
	struct lkst_log_record *startpoint;
	int                    malloc_size;
};

/* argument to function"get_filedata" */
struct lkst_arg_get_filedata {
	char*                  program_name;    /* name of Execution file             */
	int                    arg_entry_num;   /* output entry number                */
	char*                  arg_inputfile;   /* name of reading file               */
	int                    read_entry_num;  /* number of events                   */
	unsigned long          *fdata;
	struct lkst_log_record **evr;
};

/* argument to function"make_pointerarray" */
struct lkst_arg_make_pointerarray {
	char*                  program_name;    /* name of Execution file             */
	int                    arg_entry_num;   /* output entry number                */
	int                    read_entry_num;  /* number of events                   */
	unsigned long          *fdata;
	struct lkst_log_record **evr;
	int                    malloc_size;
};

/* argument to function"sort_data" */
struct lkst_arg_sort_data {
	int                    arg_sort_flag;   /* 1=(-e option published) or 0=(not) */
	int                    read_entry_num;  /* number of events                   */
	unsigned long          *fdata;
	struct lkst_log_record **evr;
};

/* argument to function"print_data" */
struct lkst_arg_print_data {
	int                    arg_entry_num;   /* output entry number                */
	int                    arg_cpu_id;      /* cpu_id                             */
	int                    arg_filter_flag; /* 1=(-e option published) or 0=(not) */
	struct lkst_log_record **evr;
	unsigned long          *fdata;
};

/* constants */
#define LKST_LOG_FMT_RET_CODE_TRUE   0
#define LKST_LOG_FMT_RET_CODE_FALSE -1           /* return number                      */
#define LKST_MAGIC_CODE              0x76758384  /* masic number                       */
#define LKST_LOG_FMT_FILE_OPEM_MODE  "rb"        /* file offset                        */
#define LKST_LOG_FMT_SORT_BUF_SIZE   256         /* work                               */
#define LKST_LOG_FMT_PRINT_SIZE      1900        /* The definition for a total years   */

#endif    /* _LINUX_BUFFER_H */

void classical_buffer_list(void);
void buffer_list(int cpu_id);
void buffer_link(int cpu, lkst_buffer_id id,
		 lkst_buffer_id next);
void buffer_create(int cpu, lkst_buffer_id id, 
		   size_t size, lkst_buffer_id nxid);
void buffer_delete(int cpu, lkst_buffer_id id);
int lkst_buffer_jump(int fd, int cpu, lkst_buffer_id dest);
int lkst_buffer_shift(int fd, int cpu);
void buffer_shift(int cpu);
void buffer_jump(int cpu, lkst_buffer_id dest);
int lkst_set_rmod(int fd, int cpu, struct lkst_log_buffer *lbuffer);
int lkst_buffer_read(int fd, struct lkst_log_buffer *lbuffer);
void buffer_write_to_file(int fd_o,
			  struct lkst_log_buffer *lbuffer);
void buffer_display(struct lkst_log_buffer *lbuffer);
void buffer_read_all(int cpu, unsigned int num, int fout);
void buffer_read(int cpu, lkst_buffer_id id, unsigned int num, int fout);

int lkst_get_status(struct lkst_status_param *sparam);

/*This macro can be used instead of 'for' statement.*/
#define for_each_online_cpus(cpu, online_map) \
	for(cpu = 0; cpu < LKST_CPU_MAX; cpu++) \
		if ( online_map & (1UL << cpu) ) 


/* END */
