/*-*-c++-*-
 * $Id: ctrace.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CTRACE_H
#define CTRACE_H

#include <qwidget.h>
#include <qpopupmenu.h>

class QListView;
class QListViewItem;
class QSplitter;

class QLcrashDoc;
class CTrace_priv;
class CTraceLowcore;

/**A trace view with disassemble window
  *@author Michael Geselbracht
  */

class CTrace : public QWidget {
   Q_OBJECT

public:
	CTrace(QLcrashDoc* doc, QWidget* parent=0, const char* name=0);
	~CTrace();
	
	// Create trace list
	void setTask();
	
	// Mark and expand process with given address
	void setMarkedProcess(const QString& addr);
	
	void expandAll();
	void collapseAll();
	
	inline const QListViewItem* selectedItem() const {
		return oSelectedItem;
	}
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	virtual void closeEvent(QCloseEvent*);
	void initPopup();
	void setAllOpen(bool w);

signals:
	void sigLowcore(CTrace* sender, const QString& addr);
	void sigClosed();
	
protected slots:
	void slotSelectionChanged(QListViewItem* item);
	// function changed
	void slotListActivated(QListViewItem* item);
	
	// display context menu
	void slotRightClicked(QListViewItem* item, const QPoint& pos, int col);
	
private:
	QListView* oFktList;
	CTrace_priv* oDisassembly;
	QSplitter* oSplitter;
	
	QLcrashDoc* oDoc;
	QListViewItem* oSelectedItem;
	QWidget* oParent;
	QPopupMenu* oTaskPopup;
	QPopupMenu* oFktPopup;
};

#endif
