/*-*-c++-*-
 * $Id: cs390dbf.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CS390DBF_H
#define CS390DBF_H

#include <qwidget.h>

class QSplitter;
class QListView;
class QListViewItem;
class QTextView;
class QLcrashDoc;
template<class T> class QList;

/**
  *@author Michael Geselbracht
  */

class CS390dbf : public QWidget {
   Q_OBJECT

public: 
	CS390dbf(QLcrashDoc* doc, QWidget* parent, const char* name=0, WFlags f=0);
	~CS390dbf();
	
	inline bool isEmpty() const {
		return oEmpty;
	}
	
protected:
	virtual void resizeEvent(QResizeEvent*);
	bool initLogList();
	void saveToFile(const QString& log, const QString& view);
	
protected slots:
	void slotInitialTimeout();
	void slotVLClicked(QListViewItem*);
	void slotVLDoubleClicked(QListViewItem*);
	void slotRightButtonClicked(QListViewItem*, const QPoint&, int);	
private:
	QLcrashDoc* oDoc;
	QSplitter* oSplitter;
	QListView* oList;
	QTextView* oText;
	bool oEmpty;
	QListViewItem* oSelectedItem;
};

#endif
