/*-*-c++-*-
 * $Id: cgraphbutton.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "cgraphbutton.h"

#include <qpainter.h>

CGraphButton::CGraphButton(QWidget* parent, const char* name) : QButton(parent, name)
{
	resize(20, 20);
	connect(this, SIGNAL(toggled(bool)), SLOT(slotToggle(bool)));
}

CGraphButton::~CGraphButton()
{
}

void
CGraphButton::drawButton(QPainter* p)
{
	p->setPen(Qt::darkGray);
	p->setBrush(Qt::NoBrush);
	p->drawRect(0, 0, width(), height());
	drawButtonLabel(p);
}

void
CGraphButton::drawButtonLabel(QPainter* p)
{
	p->setPen(Qt::NoPen);
	p->setBrush(Qt::lightGray);
	p->drawRect(2, 2, width() - 4, height() - 4);
	p->setBrush(Qt::NoBrush);
	p->setPen(Qt::white);
	p->drawLine(1, 1, width() - 1, 1);
	p->drawLine(1, 2, 1, height() - 1);
	p->setPen(Qt::gray);
	p->drawLine(1, height() - 1, width() - 1, height() - 1);
	p->drawLine(width() - 1, height() - 1, width() - 1, 1);
	
	if (pixmap() != 0) {
		p->drawPixmap(2, 2, *pixmap());
	}
}

void
CGraphButton::resizeButton()
{
	const QPixmap* p = pixmap();
	
	if (p != 0) {
		resize(p->width() + 4, p->height() + 4);
	}
}

void
CGraphButton::setOnPixmap(const QPixmap& pm)
{
	oOnPM = pm;
}

void
CGraphButton::setOffPixmap(const QPixmap& pm)
{
	oOffPM = pm;
}

void
CGraphButton::setToggle(bool w)
{
	setToggleButton(w);
}

void
CGraphButton::slotToggle(bool w)
{
	setPixmap(w ? oOnPM : oOffPM);
}
