/*-*-c++-*-
 * $Id: cdisassemble.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CDISASSEMBLE_H
#define CDISASSEMBLE_H

#include <qstring.h>

/** Contains a line of disassembled code
  */

class CDisassemble {
public: 
	CDisassemble() { }
	~CDisassemble() { }
	
	inline const QString& addr() {
		return oAddr;
	}
	inline void setAddr(const QString& addr) {
		oAddr = addr;
	}
	inline const QString& offset() {
		return oOffset;
	}
	inline void setOffset(const QString& x) {
		oOffset = x;
	}
	inline const QString& mnemonic() {
		return oMnemonic;
	}
	inline void setMnemonic(const QString& cmd) {
		oMnemonic = cmd;
	}
	
private:
	QString oAddr;
	QString oOffset;
	QString oMnemonic;
};

#endif
