/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#define STACK_SEGMENTS	1
#define STACK_SIZE	IA64_STK_OFFSET

#ifdef NOT
#define INCLUDE_REGINFO 1
#endif

#ifdef INCLUDE_REGINFO

#define NUM_REGS	8	
#define REGVAL_UNKNOWN  0
#define REGVAL_VALID    1
#define REGVAL_BAD      2  /* Value loaded into register before it was saved */

/* Register record
 */
typedef struct reg_rec {
	uaddr_t			state;
	uaddr_t			value;
} reg_rec_t;
#endif

/* Stack frame
 */
typedef struct sframe_rec {
	struct sframe_rec      *next;
	struct sframe_rec      *prev;
	int			flag;
	int			level;
	char		       *funcname;
	char		       *srcfile;
	int			line_no;
	kaddr_t			pc;
	kaddr_t			ra;
	kaddr_t			sp;
	kaddr_t			fp;
	uaddr_t		       *asp;
	int			frame_size;
	int			ptr;
	k_error_t		error;
#ifdef INCLUDE_REGINFO
	reg_rec_t		regs[NUM_REGS];
#endif
} sframe_t;

/* Stack segment structure
 */
struct stack_s {
	int			type;
	uint			size;
	kaddr_t			addr;
	uaddr_t		        *ptr;
};

/* Stack trace header
 */
typedef struct trace_rec {
	int			flags;
	kaddr_t			task;
	struct task_struct     *tsp;
	struct stack_s		stack[STACK_SEGMENTS];
	int			stackcnt;
	sframe_t	       *frame;
	int			nframes;
} trace_t;

#define TF_TRACEREC_VALID  0x01 /* The trace_rec_s has been setup already!   */
#define TF_SUPPRESS_HEADER 0x02 /* Suppress header output from trace cmds    */

/* Stack types 
 */
#define S_USERSTACK	0
#define S_KERNELSTACK	1

/* Stack frame updating macro
 */
#define UPDATE_FRAME(FUNCNAME, PC, RA, SP, FP, ASP, SRCNAME, LINE_NO, SIZE) \
        curframe->funcname = FUNCNAME; \
        curframe->pc = PC; \
        curframe->sp = SP; \
        curframe->ra = RA; \
        curframe->fp = FP; \
        curframe->asp = ASP; \
        curframe->srcfile = SRCNAME; \
        curframe->line_no = LINE_NO; \
        curframe->frame_size = SIZE; \
        curframe->ptr = curstkidx; \
        kl_enqueue((element_t **)&trace->frame, (element_t *)curframe); \
        trace->nframes++; \

/* Function prototypes
 */
void print_pc(
	kaddr_t 	/* PC */, 
	FILE *		/* output file pointer */);

sframe_t *alloc_sframe(
	trace_t *	/* Pointer to trace record */, 
	int 		/* flags */);

trace_t *alloc_trace_rec(
	int 		/* flag */);
