/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#include <lcrash.h>

/*
 * quit_cmd() -- Run the 'quit' command.
 */
int
quit_cmd(command_t *cmd)
{
	char str[256];

	if (!strcmp(cmd->command, "q")) {
		fprintf(cmd->ofp, "Do you really want to quit (y to quit) ? ");
		get_string(str, 256);
		if (str[0] == 'y' || str[0] == 'Y') {
			exit(0);
		}
	}
	else if (!strcmp(cmd->command, "quit") || !strcmp(cmd->command, "q!")) {
		exit(0);
	}
	return 1;
}

#define _QUIT_USAGE ""

/*
 * quit_usage() -- Print the usage string for the 'quit' command.
 */
void
quit_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _QUIT_USAGE);
}

/*
 * quit_help() -- Print the help information for the 'quit' command.
 */
void
quit_help(command_t *cmd)
{
	CMD_HELP(cmd, _QUIT_USAGE,
	"Exit lcrash.  Note that q will prompt for confirmation unless a "
	"'!' is appended to the command line.");
}

/*
 * quit_parse() -- Parse the command line arguments for 'quit'.
 */
int
quit_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, C_FALSE, 0)) {
		return(1);
	}
	return(0);
}
