/*
 *  lcrash/arch/s390/lib/s390-util.c
 *   S/390 utility functions
 *
 *    Copyright (C) 2000 IBM Deutschland Entwicklung GmbH,
 *                       IBM Corporation
 *    Author(s): Michael Holzheu (holzheu@de.ibm.com),
 *
 *    Bugreports to: <Linux390@de.ibm.com>
 */


#include <lcrash.h>
#include <asm/lc_s390-util.h>

extern int pc_offset(kaddr_t pc);

void s390_print_lowcore(void* lc, FILE* ofp)
{
        syment_t* sym;
	unsigned long* tmp;
        unsigned long long* ll_tmp;

        fprintf(ofp," LOWCORE INFO:\n");
	tmp = K_PTR(lc,"_lowcore","st_status_fixed_logout");
        fprintf(ofp,"  -psw      : 0x%08lx 0x%08lx\n", tmp[0],tmp[1]);

        sym = kl_lkup_symaddr(tmp[1] & 0x7fffffff);
        if(sym && (tmp != 0)){
                fprintf(ofp,"  -function : %s+%u\n",sym->s_name,
                        pc_offset(tmp[1] & 0x7fffffff));
        }
        else{
                fprintf(ofp,"  -function : not found in System map\n");
        }
	
        fprintf(ofp,"  -prefix   : 0x%08lx\n", tmp[2]);

	tmp = K_PTR(lc,"_lowcore","cpu_timer_save_area");	
        fprintf(ofp,"  -cpu timer: 0x%08lx 0x%08lx\n",tmp[0], tmp[1]);
	tmp = K_PTR(lc,"_lowcore","clock_comp_save_area");
        fprintf(ofp,"  -clock cmp: 0x%08lx 0x%08lx\n",tmp[0], tmp[1]);
        fprintf(ofp,"  -general registers:\n");
	tmp = K_PTR(lc,"_lowcore","gpregs_save_area");
        fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[0],tmp[1],tmp[2],tmp[3]);
	fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[4],tmp[5],tmp[6],tmp[7]);
	fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[8],tmp[9],tmp[10],tmp[11]);
	fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[12],tmp[13],tmp[14],tmp[15]);
        fprintf(ofp,"  -access registers:\n");
	tmp = K_PTR(lc,"_lowcore","access_regs_save_area");
	fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[0],tmp[1],tmp[2],tmp[3]);
        fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[4],tmp[5],tmp[6],tmp[7]);
        fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[8],tmp[9],tmp[10],tmp[11]);
        fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[12],tmp[13],tmp[14],tmp[15]);
        fprintf(ofp,"  -control registers:\n");
	tmp = K_PTR(lc,"_lowcore","cregs_save_area");
        fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[0],tmp[1],tmp[2],tmp[3]);
        fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[4],tmp[5],tmp[6],tmp[7]);
        fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[8],tmp[9],tmp[10],tmp[11]);
        fprintf(ofp,"     0x%08lx 0x%08lx 0x%08lx 0x%08lx\n",tmp[12],tmp[13],tmp[14],tmp[15]);
        fprintf(ofp,"  -floating point registers 0,2,4,6:\n");
	ll_tmp = K_PTR(lc,"_lowcore","floating_pt_save_area");
        fprintf(ofp,"     0x%016llx 0x%016llx\n",ll_tmp[0],ll_tmp[1]);
        fprintf(ofp,"     0x%016llx 0x%016llx\n",ll_tmp[2],ll_tmp[3]);
}

