/*-*-c++-*-
 * $Id: csymtabitem.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CSYMTABITEM_H
#define CSYMTABITEM_H

#include <qstring.h>

/**Holds informations about a (global) symbol
  *@author Michael Geselbracht
  */

class CSymtabItem {
public: 
	CSymtabItem() { /* empty */ }
	~CSymtabItem() { /* empty */ }
	
	inline const QString& address() const {
		return oAddress;
	}
	inline void setAddress(const QString& addr) {
		oAddress = addr;
	}
	inline const QString& type() const {
		return oType;
	}
	inline void setType(const QString& type) {
		oType = type;
	}
	inline const QString& name() const {
		return oName;
	}
	inline void setName(const QString& name) {
		oName = name;
	}
	
private:
	QString oAddress;
	QString oType;
	QString oName;
};

#endif
