/*-*-c++-*-
 * $Id: clistviewitem.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "clistviewitem.h"

#include <ctype.h>

CListViewItem::CListViewItem(QListView* root)
	: QListViewItem(root)
{
	setColor(black);
}

CListViewItem::CListViewItem(QListViewItem* root)
	: QListViewItem(root)
{
	setColor(black);
}

CListViewItem::CListViewItem(QListView* root, QListViewItem* after)
	: QListViewItem(root, after)
{
	setColor(black);
}

CListViewItem::CListViewItem(QListViewItem* root, QListViewItem* after)
	: QListViewItem(root, after)
{
	setColor(black);
}

CListViewItem::~CListViewItem()
{
}

QString
CListViewItem::key(int col, bool asc) const
{
	if (text(col).length() >= 1U) {
		if (isdigit(text(col)[0].latin1())) {
			QString tmp;
			int base = (text(col)[1].latin1() == 'x') ? 16 : 10;
			tmp.sprintf("%08ld", text(col).toLong(0, base));
			return tmp;
		}
	}
	
	return QListViewItem::key(col, asc);
}

void
CListViewItem::setColor(const QColor& c)
{
	oColor = c;
}

void
CListViewItem::paintCell(QPainter* p, const QColorGroup& cg, int col, int width, int align)
{
	QColorGroup ncg = cg;
	if (oColor != black) {
		ncg.setColor(QColorGroup::Text, oColor);
		ncg.setColor(QColorGroup::HighlightedText, yellow);
	}
	QListViewItem::paintCell(p, ncg, col, width, align);
}
