/*-*-c++-*-
 * $Id: chelpbrowser.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "chelpbrowser.h"
#include "qlcrashdoc.h"
#include "crashtypes.h"

#include "left.xpm"
#include "right.xpm"
#include "home.xpm"
#include "close2.xpm"

#include <qtextbrowser.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qapplication.h>

#include "resourceadapter.h"

// Tweak to make tr() reliable
#define tr(s) qApp->translate("CHelpBrowser", s)

CHelpBrowser::CHelpBrowser(QLcrashDoc* doc, QWidget* parent, const char* name )
	: QMainWindow(parent, name, WDestructiveClose)
	, oDoc(doc)
{
	setCaption(stdCaption(tr("Help")));
	setIcon(Resource::getBitmap(IDR_PNG7));
	oBrowser = new QTextBrowser(this);
	setCentralWidget(oBrowser);
	
	initToolbar();
	oBrowser->setSource(oDoc->helpHomeURL());

#if 0
	// set background pixmap
	QBrush brush;
	brush.setPixmap(QPixmap(DOCDIR "/pics/marble.png"));
	oBrowser->setPaper(brush);
#endif

	setMinimumSize(300, 300);
}

CHelpBrowser::~CHelpBrowser()
{
}

void
CHelpBrowser::initToolbar()
{
	QToolBar* tb = new QToolBar(this);
	QToolButton* b;
	
	b = new QToolButton(
		QPixmap(left_xpm),
		tr("Back"),
		QString::null,
		oBrowser,
		SLOT(backward()),
		tb
	);
	b->setAutoRaise(true);
	b = new QToolButton(
		QPixmap(right_xpm),
		tr("Forward"),
		QString::null,
		oBrowser,
		SLOT(forward()),
		tb
	);
	b->setAutoRaise(true);
	b = new QToolButton(
		QPixmap(home_xpm),
		tr("Home"),
		QString::null,
		oBrowser,
		SLOT(home()),
		tb
	);
	b->setAutoRaise(true);
	b = new QToolButton(
		QPixmap(close2_xpm),
		tr("Close"),
		QString::null,
		this,
		SLOT(close()),
		tb
	);
	b->setAutoRaise(true);
}

