/*-*-c++-*-
 * $Id: cgraphobject.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CGRAPHOBJECT_H
#define CGRAPHOBJECT_H

#include "crashtypes.h"

#include <qframe.h>
#include <qlist.h>
#include <qarray.h>

class CGraphManager;
class CGraphObject;
class CGraphButton;
class CGraphLabel;
class QLabel;

struct SMoveInfo {
	CGraphObject* child;
	int newX;
	int newY;
};

/**
  *@author Michael Geselbracht
  */

class CGraphObject : public QFrame {
   Q_OBJECT

public:
	enum ResizeType { NoResize=0, VerTop=1, VerBot=2, HorLeft=4, HorRight=8};
	
	CGraphObject(CGraphManager* parent, const char *name=0);
	~CGraphObject();
	
	inline QWidget* widget() { return oWidget; }
	void setWidget(QWidget* w);
	void replaceWidget(QWidget* w, bool keepSize=false);
	
	/** Return the parent object which is connected to this object. */
	inline CGraphObject* parent() { return oParent; }
	inline void setParent(CGraphObject* p) { oParent = p; }
	inline bool isRoot() const { return oParent == 0; }
	
	void addChild(CGraphObject*);
	void removeChild(CGraphObject*);
	
	inline void setWireLabel(const QString& str) { oWireLabel = str; }
	inline QString wireLabel() const { return oWireLabel; }
	
	inline QList<CGraphObject>* childList() { return &oChildList; }
	
	void setIcon(const QPixmap&);
	virtual void setCaption(const QString& capt);
	
	void setPaintFocus(bool w);
	
	inline QArray<CLine>& destinations() {
		return oDestination;
	}
	
	virtual void setCursor(const QCursor&);
	virtual void unsetCursor();
	
	bool isViewMany() const;
	inline CGraphObject* oneChild() const {
		return oOneChild;
	}
	inline void setOneChild(CGraphObject* obj) {
		oOneChild = obj;
	}
	
signals:
	void sigClicked(CGraphObject*);
	void sigClose(CGraphObject*);
	void sigDisc(CGraphObject*);
	void sigMoved(CGraphObject*);
	
public slots:
	void slotClose();
	
protected:
	enum MoveType { None, Move, Resize };
	virtual void resizeEvent(QResizeEvent*);
	virtual void paintEvent(QPaintEvent*);
	virtual void mousePressEvent(QMouseEvent*);
	virtual void mouseReleaseEvent(QMouseEvent*);
	virtual void mouseMoveEvent(QMouseEvent*);
	virtual void leaveEvent(QMouseEvent*);
	bool eventFilter(QObject*, QEvent*);
	void moveViewport(QMouseEvent*);
	void initTitleBar();

private slots:
	void slotLabelMoved(QMouseEvent*);
	void slotLabelPressed(QMouseEvent*);
	void slotLabelReleased(QMouseEvent*);
	
	// Disconnect from parent
	void slotDisc();
	
	// From now on, display only one additional child
	void slotView(bool);
	
private:
	CGraphObject* oParent;
	CGraphButton* oCloseB;
	CGraphButton* oDiscB;
	CGraphButton* oViewB;
	QList<CGraphObject> oChildList;
	QWidget* oWidget;
	QString oWireLabel;
	QLabel* oIcon;
	CGraphLabel* oCaption;
	long oOldX;
	long oOldY;
	MoveType oMoveAction;
	ResizeType oResizeAction;
	CGraphManager* oManager;
	bool oHaveFocus;
	QArray<CLine> oDestination;
	
	// single child mode
	CGraphObject* oOneChild;
};

#endif
