/*-*-c++-*-
 * $Id: cchildimplementation.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef _CCHILDIMPLEMENTATION_H_
#define _CCHILDIMPLEMENTATION_H_

class QString;
class QWidget;

#include <qobject.h>
#include <qmap.h>
#include <qstring.h>

typedef QMap<QString,QString> cfgMap;

class CChildImplementation : public QObject {
	Q_OBJECT

public:
	CChildImplementation() : QObject(0) {
		_activated = false; _configured = false;
	}
	CChildImplementation(const CChildImplementation&) : QObject(0) {
		_activated = false; _configured = false;
	}

	virtual bool writeStdin(QString) = 0;

	/**
	 * Check, if program exists and is a
	 * valid executable.
	 */
	virtual bool valid() = 0;

	/** Create a child process.
	 */
	virtual void forkChild() = 0;

	/** Check if child is running.
	 */
	virtual bool running() = 0;

	/** Send string to child and return answer.
	 */
	//virtual bool command(QString cmd, QString& result, int maxCycle=200) = 0;

	/** Kill child by sending the sequence
	 * `sigterm' and `sigkill' if sig is zero.
	 * Otherwise signal sig is sent to the child.
	 */
	virtual void killChild(int sig=0) = 0;

	/**
	 * Configure this instance.
	 * Creates a modal Dialog for configuration.
	 * Upon return, delivers usual Dialog-Returncodes.
	 * Instances which do not provide any configurable
	 * items should return Accepted immediately without
	 * creating a Dialog.
	 */
	virtual int configure(QWidget *parent) = 0;

	virtual cfgMap getConfigValues() = 0;

	virtual void setConfigValues(cfgMap) = 0;

	virtual bool configured() = 0;

	virtual bool activated() {return _activated;}

	virtual void activate(bool b) {_activated = b;}

signals:
	void sigChildDied();
	void sigChildStarted();
	void sigBusy();
	void sigStdout(QString);
	void sigStderr(QString);

protected:
	bool _configured;
	bool _activated;
};

#ifdef __CCHILD_INTERNAL

#ifdef __cplusplus
extern "C" {
#endif

typedef CChildImplementation *(*factory_func_t)();

typedef struct {
	int magic;
	int configurable;
	factory_func_t factory;
	/* The following provided only for display */
	const char *name;
	const char *version;
	const char *description;
	const char *author;
	const char *copyright;
} plugin_header_t;

#ifdef __cplusplus
};
#endif

#define PLUGIN_MAGIC 0x01020304
#define PLUGIN_STRUCT_NAME     qlcrash_plugin_info
#define PLUGIN_STRUCT_NAME_STR "qlcrash_plugin_info"

#define DECLARE_PLUGIN(name, version, descr, author, copyr, factory, cfgflag) \
extern const plugin_header_t PLUGIN_STRUCT_NAME = { \
	PLUGIN_MAGIC, \
	cfgflag, \
	factory, \
	name, \
	version, \
	descr, \
	author, \
	copyr \
}

#endif // __CCHILD_INTERNAL

#endif
/*
 * Local variables:
 * c-basic-offset: 8
 * End:
 */
