/*-*-c++-*-
 * $Id: caction.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CACTION_H
#define CACTION_H

#include <qaction.h>

class CAction : public QAction {
	Q_OBJECT
	
public:
	CAction(QObject* parent) : QAction(parent), oDefCode(0) {
		connect(this, SIGNAL(activated()), SLOT(slotActivated()));
	}
	
	inline int defCode() const {
		return oDefCode;
	}
	inline void setDefCode(int c) {
		oDefCode = c;
	}
	inline int id() const {
		return oId;
	}
	inline void setId(int i) {
		oId = i;
	}

signals:
	void sigAction(CAction*);
	
private slots:
	void slotActivated() {
		emit sigAction(this);
	}
	
private:
	int oDefCode;
	int oId;
};

#endif
