#include <lcrash.h>

extern int get_dump_header_asm(dump_header_asm_t *);

int defcpu = -1;

/*
 * deftask_cmd() -- Run the 'deftask' command.
 */
int
defcpu_cmd(command_t *cmd)
{
	dump_header_asm_t dha;
	int cpu;

	if (cmd->nargs == 0) {
		if (defcpu == -1) {
			fprintf(cmd->efp, "No default cpu set\n");
		} else {
			fprintf(cmd->ofp, "Default cpu is %d\n", defcpu);
		}
		return(0);
	} 

	if (MIP->core_type != reg_core) {
		fprintf(cmd->efp, "Can't use this command on live system\n");
		return (1);
	}
	if (get_dump_header_asm(&dha))
		return (1);

	cpu = strtol(cmd->args[0], NULL, 10);

	if (cpu >= dha.dha_smp_num_cpus) {
		fprintf(cmd->efp, "Error setting defcpu to %s\n", cmd->args[0]);
		return (1);
	}
	defcpu = cpu;
	fprintf(cmd->ofp, "Default cpu is %d\n", defcpu);

	if (dha.dha_stack[defcpu]) {
		deftask = (kaddr_t)dha.dha_smp_current_task[defcpu];
		fprintf(cmd->ofp, "Default task is 0x%x\n", deftask);
	}
	return (0);
}

#define _DEFCPU_USAGE	"[-w outfile] [cpu]"

/*
 * defcpu_usage() -- Print the usage string for the 'defcpu' command.
 */
void
defcpu_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _DEFCPU_USAGE);
}

/*
 * defcpu_help() -- Print the help information for the 'defcpu' command.
 */
void
defcpu_help(command_t *cmd)
{
	CMD_HELP(cmd, _DEFCPU_USAGE,
	"Set the default cpu if one is indicated. Otherwise print the "
	"value of default cpu." 
        "When 'lcrash' is run on a live system, defcpu has no "
        "meaning.\n\n"
	"This command also sets the default task to the task running "
	"on the default cpu at the time the dump is taken. "
	"The rd command will display the registers on the default cpu "
	"at the time the dump is taken. "
        "The trace command will display a trace wrt the task "
        "running on the default cpu at the time the dump is taken. ");
}

/*
 * defcpu_parse() -- Parse the command line arguments for 'defcpu'.
 */
int
defcpu_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_WRITE), 0)) {
		return(1);
	}
	return(0);
}
