/* $Id: lkstm.c,v 1.7 2002/06/28 11:27:53 indoh Exp $ */
/* command/lkstm.c */

/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2002 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by K.Hatasaki <keisukeh@crl.hitachi.co.jp>
 *
 ************************************************************/

#include "command.h"

#define NAME	"lkstm"
#define VERSION "1.2"

#define NR_CMD	13

void usage(void);

void call_usage(int* , char**);
void call_version(int*, char**);
void call_all(int*, char**);
void call_list(int*, char**);
void call_del(int*, char**);
void call_read(int*, char**);
void call_set(int*, char**);
void call_xchg(int*, char**);
void call_write(int*, char**);

int main(int argc, char **argv)
{
	int i;

	struct command cmd[] = 
	{
		[0] = {"help", &call_usage},
		[1] = {"ver", &call_version},
		[2] = {"version", &call_version},
		[3] = {"all", &call_all},
		[4] = {"list", &call_list},
		[5] = {"ls", &call_list},
		[6] = {"delete", &call_del},
		[7] = {"del", &call_del},
		[8] = {"read", &call_read},
		[9] = {"set", &call_set},
		[10] = {"exchange", &call_xchg},
		[11] = {"xchg", &call_xchg},
		[12] = {"write", &call_write}
	};

	if (argc == 1) { /* no command */
		usage();
	} else {
		for (i = 0; i < NR_CMD; i++) {
			if (!strcmp(cmd[i].name, argv[1])) {
				cmd[i].func(&argc, argv);
				break;
			}
		}
		if (i == NR_CMD)
			badcommand(argv[1]);
	}

	exit(0);
}


void usage(void)
{
	printf("This controls masksets.\n");
	printf("Usage:\n\t%s command [option(s)]\n\n", NAME);
	printf("<COMMAND>\n");
	printf("all\t\tOutput a list of masksets and display content of all masksets.\n");
	/*printf("exchange/xchg\tChange a currently selected maskset and display id of old one.\n");*/
	printf("\t\t<OPTION>\n");
	printf("\t\t-m maskset_id\n");
	printf("delete/del\tDelete a maskset.\n");
	printf("list/ls\t\tOutput a list of all masksets.\n");
	printf("read\t\tOutput a content of maskset(s).\n");
	printf("\t\t<OPTION>\n");
	printf("\t\t[-m maskset_id] [-A] [-a] [-d]\n");
	printf("set\t\tChange to sepecified maskset.\n");
	printf("\t\t<OPTION>\n");
	printf("\t\t-m maskset_id\n");
	printf("write\t\tWrite a new maskset.\n");
	printf("\t\t<OPTION>\n");
	printf("\t\t[-m maskset_id] [-f file_name] [-n maskset_name] [-S]\n");
	printf("version/ver\tPrint version information.\n");
	printf("help\t\tPrint this message.\n");
	exit(0);
}

void call_usage(int *argc, char **argv)
{
	usage();
}

void call_version(int *argc, char **argv)
{
	version(NAME, VERSION);
}

void call_all(int *argc, char **argv)
{
	maskset_list();
	maskset_read_all(0, 0);	/* display name of events */
}

void call_list(int *argc, char **argv)
{
	maskset_list();
}

void call_del(int *argc, char **argv)
{
	int c;
	lkst_maskset_id id;

	c = getopt(*argc, argv, "m:");

	switch(c) {
	case 'm' :
		id = atoi(optarg);
		break;
	case -1:
		needopt();
		break;
	default :
		usage();
		break;
	}

	maskset_delete(id);
}

void call_read(int *argc, char **argv)
{
	int c;
	int rall = 0;
	int all = 0;
	int disp = 0;
	lkst_maskset_id id = LKST_MASKSET_ID_VOID;

	while((c = getopt(*argc, argv, "m:Aad")) != EOF) {
		switch(c) {
		case 'm' :
			id = atoi(optarg);
			break;
		case 'A' :
			rall = 1;
			break;
		case 'a' :
			all = 1;
			break;
		case 'd' :
			disp = 1;
			break;
		default :
			usage();
		}
	}

	if (rall)
		maskset_read_all(all, disp);
	else
		maskset_read(id, all, disp);

}

void call_set(int *argc, char **argv)
{
	int c;
	lkst_maskset_id id;

	c = getopt(*argc, argv, "m:");

	switch(c) {
	case 'm' :
		id = atoi(optarg);
		break;
	case -1:
		needopt();
		break;
	default :
		usage();
		break;
	}

	maskset_set(id);
}

void call_xchg(int *argc, char **argv)
{
	int c;
	lkst_maskset_id id;

	c = getopt(*argc, argv, "m:");

	switch(c) {
	case 'm' :
		id = atoi(optarg);
		break;
	case -1:
		needopt();
		break;
	default :
		usage();
		break;
	}

	maskset_xchg(id);
}

void call_write(int *argc, char **argv)
{
	int c;
	int i;
	int set = 0;
	lkst_maskset_id id = LKST_MASKSET_ID_VOID;
	char file_name[255];
	char maskset_name[255];

	strncpy(maskset_name, "new_maskset", 12);
	strncpy(file_name, "-", 2); /* standard input */

	while((c = getopt(*argc, argv, "m:n:f:S")) != EOF) {
		switch(c) {
		case 'm' :
			id = atoi(optarg);
			break;
		case 'n' :
			strncpy(maskset_name, optarg, 255);
			break;
		case 'f' :
			strncpy(file_name, optarg, 255);
			break;
		case 'S' :
			set = 1;
			break;
		default :
			usage();
		}
	}

	maskset_write(&id, file_name, maskset_name);

	if (set)
		maskset_set(id);
}
