#!/bin/sh
[ $# -ne 1 -a $# -ne 2 ] && echo "usage: disym.sh <kernel_symbol> [kernel-version]" && exit 0
SYM=$1
KVER=$2
[ -z "$KVER" ] && KVER=`uname -r`

function cntarg () {
return $#
}

SYSMAP=/lib/modules/$KVER/build/System.map
VMLINUX=/lib/modules/$KVER/build/vmlinux

XADDR=`grep " $SYM"$ $SYSMAP | cut -f 1 -d\ `
if [ -z "$XADDR" ] ; then 
	echo "Error : $SYM was not found in "$SYSMAP
	exit 0;
fi
SADDR=`printf "%d" 0x$XADDR` 
EADDR=`expr $SADDR + 5`
objdump --start-address=$SADDR --stop-address=$EADDR -j ".text" -d $VMLINUX
echo 
LLINE=`objdump --start-address=$SADDR --stop-address=$EADDR -j ".text" -d $VMLINUX | tail -n 1 | cut -b1-32` 
EXADDR=`echo $LLINE | cut -f 1 -d:`
cntarg `echo $LLINE | cut -b10-24`
DIFF=$?
EADDR=`printf "%d" 0x$EXADDR`
SIZE=`expr $EADDR - $SADDR + $DIFF`
echo "Please be sure that the above-disassembled instructions are relocatable."
echo "Parameter: addr=0x$XADDR size=$SIZE"
