/*
 djprobe -- Direct jmp-insertion probe
 Copyright (c) 2005 Hitachi,Ltd.,
 Created by Masami Hiramatsu<hiramatu@sdl.hitachi.co.jp>
  
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __DJPROBE_H__
#define __DJPROBE_H__

#include <linux/kprobes.h>
#include <linux/cpumask.h>

/*
 * architecture depending code (must be in asm-i386)
 */
/* stub template code */
extern long arch_tmpl_stub_entry;
extern long arch_tmpl_stub_val;
extern long arch_tmpl_stub_call;
extern long arch_tmpl_stub_inst;
extern long arch_tmpl_stub_end;
struct djprobe_instance;
extern void asmlinkage djprobe_callback(struct djprobe_instance * djpi,
					struct pt_regs * regs);

#define ARCH_STUB_INSN_SIZE 80
#define ARCH_STUB_VAL_IDX ((long)&arch_tmpl_stub_val - (long)&arch_tmpl_stub_entry + 1)
#define ARCH_STUB_CALL_IDX ((long)&arch_tmpl_stub_call - (long)&arch_tmpl_stub_entry + 1)
#define ARCH_STUB_INST_IDX ((long)&arch_tmpl_stub_inst - (long)&arch_tmpl_stub_entry)
#define ARCH_STUB_END_IDX ((long)&arch_tmpl_stub_end - (long)&arch_tmpl_stub_entry)
#define ARCH_STUB_SIZE ((long)&arch_tmpl_stub_end - (long)&arch_tmpl_stub_entry + 5)

#define ARCH_STUB_INSN_MAX (ARCH_STUB_END_IDX - ARCH_STUB_INST_IDX)
#define ARCH_STUB_INSN_MIN 5

#define RELATIVEJUMP_INSTRUCTION 0xe9
#define RETURN_INSTRUCTION 0xc3

struct arch_djprobe_stub {
	kprobe_opcode_t insn[ARCH_STUB_INSN_SIZE];
	int size;
};

/*
 * general code 
 */
struct djprobe_instance {
	struct kprobe kp;
	struct djprobe *djp;
	struct arch_djprobe_stub stub;

	struct list_head list; /* list of djprobe_instances */
	cpumask_t checked_cpus;
	int state;
};

#define DJPI_EMPTY(djpi)  (djpi->djp==NULL)

/* state */ 
enum {
	DJST_DISABLE = 0, /* prepared to install/free (bypassing) */
	DJST_ENABLE = 1,  /* installed */
	DJST_RELEASING = 2, /* scheduled to free */
};

typedef void (*djprobe_handler_t)(struct djprobe *ap, struct pt_regs *regs);

/*
 * Direct Jump probe interface structure
 */
struct djprobe {
	void * addr;
	int size;
	djprobe_handler_t handler;
	struct djprobe_instance * inst;
};

int register_djprobe(struct djprobe *djp);
void unregister_djprobe(struct djprobe *djp);

#endif
